#!/usr/bin/bash
#
# Copyright 2025 MicroSys Electronics GmbH
#

SDKNATIVESYSROOT=/sdk/sysroots/x86_64-mslsdk-linux

CST_DIR=${SDKNATIVESYSROOT}/usr/bin/cst
BOOT_DIR=${SDKNATIVESYSROOT}/usr/share/boot

CREATE_PBL=${SDKNATIVESYSROOT}/usr/bin/create_pbl

source ${BOOT_DIR}/isbc_param_sd.env

BL2_INPUT_FILE=${BOOT_DIR}/csf_hdr_parser/${BL2_INPUT_FILE}
PBI_INPUT_FILE=${BOOT_DIR}/csf_hdr_parser/${PBI_INPUT_FILE}
RCW=${BOOT_DIR}/rcw/${BOOT_MODE}/${RCW}

bl2_hdr_loc=$(( ${BL2_HDR_SRC_OFFSET} / 1024 ))
bl2_loc=$(( ${BL2_SRC_OFFSET} / 1024 ))

${CST_DIR}/create_hdr_isbc --in ${BOOT_DIR}/bl2.bin --out hdr_bl2 ${BL2_INPUT_FILE}

${CREATE_PBL} -r ${RCW} -i ${BOOT_DIR}/bl2.bin -b ${BOOT_MODE} -c ${SOC_NUM} -d ${BL2_BASE} -e ${BL2_BASE} -o bl2_${BOOT_MODE}.pbl -f ${BL2_SRC_OFFSET}

${CREATE_PBL} -r bl2_${BOOT_MODE}.pbl -i hdr_bl2 -b ${BOOT_MODE} -c ${SOC_NUM} -d ${BL2_HDR_LOC} -e ${BL2_HDR_LOC} -s -f ${BL2_HDR_SRC_OFFSET} -o rcw_sec.pbl

${CST_DIR}/create_hdr_pbi --out bl2_${BOOT_MODE}_sec.pbl --in rcw_sec.pbl ${PBI_INPUT_FILE}

dd if=hdr_bl2 of=bl2_${BOOT_MODE}_sec.pbl bs=1K seek=${bl2_hdr_loc}
dd if=${BOOT_DIR}/bl2.bin of=bl2_${BOOT_MODE}_sec.pbl bs=1K seek=${bl2_loc}

