#
# Copyright (C) 2020-2025 MicroSys Electronics GmbH
#

SUMMARY = "Secure boot tools"
DESCRIPTION = "Installs tools for signing boot images"
LICENSE = "CLOSED"

inherit allarch

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:"

SRC_URI = "file://isbc_sign.sh"

DEPENDS += "qoriq-atf u-boot-qoriq rcw linux-qoriq u-boot-binman"
DEPENDS += "itsgen"

do_fetch[noexec] = "1"
do_patch[noexec] = "1"
do_configure[noexec] = "1"

do_install:append() {

    install -m 0755 -d ${D}${bindir}
    install -m 0755 -d ${D}${datadir}

    install -m 0755 ${WORKDIR}/isbc_sign.sh ${D}${bindir}/isbc_sign

    cd ${DEPLOY_DIR_IMAGE}/secure-boot
    cp -a usr/bin/* ${D}${bindir}
    cp -a usr/share/* ${D}${datadir}
    chown -R root:root ${D}${bindir}
    chown -R root:root ${D}${datadir}
}

FILES:${PN} += "${bindir} ${datadir}"

INSANE_SKIP += "file-rdeps"
INSANE_SKIP += "arch buildpaths"

BBCLASSEXTEND += "native nativesdk"

