# Copyright (C) 2024 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>

SUMMARY = "ITS Generator"
DESCRIPTION = "Generates ITS files for mkimage"
LICENSE = "CLOSED"

inherit allarch

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:"

SRC_URI = "file://itsgen.py"

do_patch[noexec]     = "1"
do_configure[noexec] = "1"
do_compile[noexec]   = "1"

do_install:append() {
    install -d ${D}/${bindir}
    install -m 0755 ${WORKDIR}/itsgen.py ${D}/${bindir}/itsgen
}

do_deploy:append() {
    install -d ${DEPLOYDIR}/secure-boot/${bindir}
    install -m 0755 ${WORKDIR}/itsgen.py ${DEPLOYDIR}/secure-boot/${bindir}/itsgen
}

INSANE_SKIP += "file-rdeps"

BBCLASSEXTEND = "native nativesdk"
