# Copyright (C) 2019 MicroSys Electronics GmbH, Author Kay Potthoff
# Author: Kay Potthoff <kay.potthoff@microsys.de>

SUMMARY = "Shell profiles"
DESCRIPTION = "Installs profiles for user root"
LICENSE = "CLOSED"

inherit allarch

FILES:${PN} += "${ROOT_HOME}/.bashrc"
FILES:${PN} += "${ROOT_HOME}/.profile"
FILES:${PN} += "${ROOT_HOME}/.xdg"
FILES:${PN}_mpxs32g274a += "${ROOT_HOME}"
FILES:${PN}_mpxs32g274a += "/etc/udev/rules.d/99-rtc1.rules"

do_unpack[noexec] = "1"
do_fetch[noexec] = "1"
do_patch[noexec] = "1"
do_configure[noexec] = "1"

do_compile() {
  echo "export XDG_RUNTIME_DIR=~/.xdg" > ${B}/bashrc
  echo "alias ll='ls -lF --time-style=long-iso'" >> ${B}/bashrc
  echo "source ~/.bashrc" > ${B}/profile
}

do_install() {
  install -d ${D}${ROOT_HOME}
  install -d -m 0700 ${D}${ROOT_HOME}/.xdg

  install -m 0644 ${B}/bashrc ${D}${ROOT_HOME}/.bashrc
  install -m 0644 ${B}/profile ${D}${ROOT_HOME}/.profile
}

do_clean() {
  for p in ${B}/bashrc ${B}/profile; do
    if [ -f ${p} ]; then rm -f ${p}; fi
  done
}
