# Copyright (C) 2022-2025 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>

LICENSE = "GPLv2"

LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/GPL-2.0;md5=801f80980d171dd6425610833a22dbe6"

require recipes-core/images/core-image-minimal.bb

SSTATE_SKIP_CREATION = "1"

do_image_ramdisk[deptask] += "do_image_ext4"

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:"

DEPENDS += "u-boot-tools-native itsgen-native dtc-native"

PACKAGE_ARCH = "${MACHINE_ARCH}"

IMAGE_FSTYPES = "ext4.gz ramdisk jffs2.sum ubifs ubi"

addtask do_image_ext4 before do_image_ramdisk

do_rootfs:append() {
    img = os.path.join(d.getVar('IMAGE_ROOTFS'), "/boot/Image.gz")
    if os.path.isfile(img):
        os.unlink(img)
}
