# Copyright (C) 2022-2025 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>

inherit deploy

UBOOT_INITIAL_ENV ?= "${@get_uboot_env(d)}"

SSTATE_SKIP_CREATION = "1"

MICROSYS_IMAGE_EXTRA_INSTALL += " \
    parted e2fsprogs-resize2fs can-utils bashprofile \
    stressapptest whetstone dhrystone iperf3 memtester \
    linux-qoriq-tools libgpiod libgpiod-tools btrfs-tools \
    cpufrequtils cpupower cpulimit \
"

IMAGE_INSTALL:append = " ${MICROSYS_IMAGE_EXTRA_INSTALL}"

SDCARD_ROOTFS = "${IMGDEPLOYDIR}/${IMAGE_BASENAME}-${MACHINE}.rootfs.ext4"
FLASH_ROOTFS  = "microsys-image-ramdisk-${MACHINE}.rootfs.jffs2.sum"

DEPENDS += "microsys-image-ramdisk itsgen-native dtc-native parted-native u-boot-binman-native"

do_image_ext4[depends] += "e2fsprogs-native:do_populate_sysroot"

do_image_tfa_sdcard[depends] += "${PN}:do_image_ext4"
do_image_tfa_sdcard[depends] += "${PN}:do_image_btrfs"
do_image_tfa_sdcard[depends] += "microsys-image-ramdisk:do_image_complete"

do_image_ppc_sdcard[depends] += "${PN}:do_image_ext4"
do_image_ppc_sdcard[depends] += "${PN}:do_image_btrfs"
do_image_ppc_sdcard[depends] += "microsys-image-ramdisk:do_image_complete"

IMAGE_FSTYPES:qoriq     = "ext4 btrfs tfa-sdcard flash"
IMAGE_FSTYPES:qoriq-ppc = "ext4 btrfs ppc-sdcard flash"

do_rootfs_add_ramdisk() {
    install -m 0644 ${DEPLOY_DIR_IMAGE}/${RAMDISK_IMAGE_NAME}.ramdisk ${IMAGE_ROOTFS}/${KERNEL_IMAGEDEST}
    ln --force --symbolic --no-dereference ${RAMDISK_IMAGE_NAME}.ramdisk ${IMAGE_ROOTFS}/${KERNEL_IMAGEDEST}/microsys-fit-image.ramdisk
}
addtask do_rootfs_add_ramdisk after do_rootfs before do_image
do_rootfs_add_ramdisk[depends] += "microsys-image-ramdisk:do_image_complete"

BINMAN = "${STAGING_DATADIR_NATIVE}/u-boot/tools/binman/binman"

