# Copyright (C) 2024 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>
# Co-author: Hajrudin Cerimovic <hajrudin.cerimovic@microsys.de>

require recipes-fsl/images/fsl-image-networking.bb

require microsys-image-networking.inc

MACHINE_ESSENTIAL_EXTRA_RRECOMMENDS += "${@bb.utils.contains('DISTRO_FEATURES', \
    'hailo', 'kernel-module-hailo-pci', '', d)}"

IMAGE_INSTALL:append = "${@bb.utils.contains('DISTRO_FEATURES', \
    'hailo', \
    ' libhailort hailortcli pyhailort libgsthailo hailo-pci hailo-firmware ', \
    '', d)}"

IMAGE_INSTALL:append = "${@bb.utils.contains('DISTRO_FEATURES', \
    'hailo', \
    ' libgsthailotools hailo-post-processes tappas-tracers ', \
    '', d)}"

#meta-hailo-accelerator
HAILO_PACKAGE += "hailo-pci"
HAILO_PACKAGE += "hailo-firmware"

#meta-hailo-libhailort
HAILO_PACKAGE += "libgsthailo"
HAILO_PACKAGE += "hailortcli"
HAILO_PACKAGE += "libhailort"
HAILO_PACKAGE += "pyhailort"
HAILO_PACKAGE += "pyhailort-shared"
HAILO_PACKAGE += "python3-verboselogs"

#meta-hailo-tappas
HAILO_PACKAGE += "cxxopts"
HAILO_PACKAGE += "hailo-post-processes"
HAILO_PACKAGE += "libgsthailotools"
HAILO_PACKAGE += "rapidjson"
HAILO_PACKAGE += "tappas-apps"
HAILO_PACKAGE += "tappas-tracers"
HAILO_PACKAGE += "xtensor"
HAILO_PACKAGE += "xtl"

CORE_IMAGE_EXTRA_INSTALL += "${HAILO_PACKAGE}"
