# Copyright (C) 2021-2024 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:"
PATCHTOOL = "git"

SRC_URI:append = " file://linux.patch"

# Tag: lf-6.6.52-2.2.0
# Note: the SRCREV/tag has been updated from
#       lf-6.6.23-2.0.0 to lf-6.6.52-2.2.0
SRCREV = "e0f9e2afd4cff3f02d71891244b4aa5899dfc786"

DEPENDS += "u-boot-tools-native dtc-native itsgen-native"

PROVIDES += "nativesdk-${PN}"

KERNEL_IMAGETYPE ??= "Image.gz"

UBOOT_DTB_LOADADDRESS ??= "0x90000000"

FDT_BLOB = "${@' --fdt '.join([os.path.join(d.getVar('B'), \
                              d.getVar('KERNEL_OUTPUT_DIR'), \
                              'dts', dtb)+":load=${UBOOT_DTB_LOADADDRESS}" \
                              for dtb in d.getVar('KERNEL_DEVICETREE').split()])}"

LINUX_TOOLS ?= "leds usb gpio"

do_compile:append() {

    itsgen --file ${B}/${KERNEL_FIT_IMAGE}-${MACHINE}.its \
           --arch ${TARGET_ARCH} \
           --kernel ${B}/${KERNEL_OUTPUT_DIR}/${KERNEL_IMAGETYPE}:entry=${UBOOT_ENTRYPOINT}:load=${UBOOT_LOADADDRESS} \
           --fdt ${FDT_BLOB} \
           --no-hash

    mkimage -f ${B}/${KERNEL_FIT_IMAGE}-${MACHINE}.its ${B}/${KERNEL_FIT_IMAGE}-${MACHINE}.itb

    # Build Linux tools

    cd ${S}
    oe_runmake -C tools/ ${LINUX_TOOLS}
}

do_install:append() {

    install -d ${D}/${KERNEL_IMAGEDEST}

    install -m 0644 ${B}/${KERNEL_FIT_IMAGE}-${MACHINE}.itb ${D}/${KERNEL_IMAGEDEST}

    ln --force --symbolic --no-dereference ${KERNEL_FIT_IMAGE}-${MACHINE}.itb ${D}/${KERNEL_IMAGEDEST}/${KERNEL_FIT_IMAGE}.itb

    for dtb in ${KERNEL_DEVICETREE}; do
    	install -m 0644 ${B}/${KERNEL_OUTPUT_DIR}/dts/${dtb} ${D}/${KERNEL_IMAGEDEST}
    done

    # Install Linux tools
    # (the Makefile in tools/ doesn't install the tools with root ownership
    # therefore, we're doing this manually here)

    install -d -o root -g root ${D}${bindir}

    if ${@bb.utils.contains('LINUX_TOOLS', 'gpio', 'true', 'false', d)}; then
       install -m 0755 -o root -g root ${S}/tools/gpio/lsgpio ${D}${bindir}
       install -m 0755 -o root -g root ${S}/tools/gpio/gpio-event-mon ${D}${bindir}
       install -m 0755 -o root -g root ${S}/tools/gpio/gpio-hammer ${D}${bindir}
    fi

    if ${@bb.utils.contains('LINUX_TOOLS', 'led', 'true', 'false', d)}; then
        install -m 0755 -o root -g root ${S}/tools/leds/uledmon ${D}${bindir}
    fi

    if ${@bb.utils.contains('LINUX_TOOLS', 'usb', 'true', 'false', d)}; then
        install -m 0755 -o root -g root ${S}/tools/usb/testusb ${D}${bindir}
    fi

    if ${@bb.utils.contains('LINUX_TOOLS', 'spi', 'true', 'false', d)}; then
       install -m 0755 -o root -g root ${S}/tools/spi/spidev_test ${D}${bindir}
    fi
}

do_deploy:append() {
	install -m 0755 -d ${DEPLOYDIR}/secure-boot/${datadir}/kernel
	install -m 0644 ${B}/${KERNEL_OUTPUT_DIR}/${KERNEL_IMAGETYPE} ${DEPLOYDIR}/secure-boot/${datadir}/kernel
	for dtb in ${KERNEL_DEVICETREE}; do
	    install -m 0644 ${B}/${KERNEL_OUTPUT_DIR}/dts/${dtb} ${DEPLOYDIR}/secure-boot/${datadir}/kernel
	done
}

FILES:${KERNEL_PACKAGE_NAME}-image += "/${KERNEL_IMAGEDEST}/${KERNEL_FIT_IMAGE}*"
FILES:${KERNEL_PACKAGE_NAME}-image += "/${KERNEL_IMAGEDEST}/*.dtb"

COMPATIBLE_MACHINE = "(qoriq)"

PACKAGES += "${PN}-tools"

FILES:${PN}-tools += " \
   ${bindir} \
"

INSANE_SKIP:${PN}-tools = "ldflags debug-files"

BBCLASSEXTEND += "nativesdk"

