#
# Copyright (C) 2021-2025 MicroSys Electronics GmbH
#

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:"

SRC_URI += "\
	file://80-microsys-networking.rules \
	file://eth-dpmac \
"

RDEPENDS:${PN} += "perl"

S = "${WORKDIR}"
RULE:qoriq-arm64 += "80-microsys-networking.rules"

do_install () {
    install -d ${D}${sysconfdir}/udev/rules.d/
    for r in ${RULE}; do
        install -m 0644 ${WORKDIR}/${r} ${D}${sysconfdir}/udev/rules.d/
    done

    install -d ${D}${bindir}
    install -m 0755 eth-dpmac ${D}${bindir}
}

ALLOW_EMPTY:${PN} = "1"

COMPATIBLE_MACHINE = "(qoriq)"
PACKAGE_ARCH = "${MACHINE_SOCARCH}"
