# Copyright (C) 2020-2025 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>

require u-boot-ms-common.inc

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:"

DEPENDS:append:qoriq-ppc = " rcw"
DEPENDS:append:qoriq-ppc = " bison-native flex-native"

PV:remove = "fslgit"
PV:remove = "+"

PROVIDES += "nativesdk-${PN}"

python do_patch:prepend() {
    if d.getVar('PATCHTOOL') == 'git':
        srcsubdir = d.getVar('S')
        bb.process.run('git config am.threeWay true', cwd=srcsubdir)
        bb.process.run('git config am.keepcr true', cwd=srcsubdir)
        bb.process.run('git config apply.whitespace fix', cwd=srcsubdir)
        bb.process.run('git config apply.ignoreWhitespace change', cwd=srcsubdir)
}

do_deploy:append() {

    cd ${B}
    install -d ${DEPLOYDIR}

    if [ -f ${UBOOT_MACHINE}/${DPC_DEVICETREE}.dtb ]; then
        install -m 0644 ${UBOOT_MACHINE}/${DPC_DEVICETREE}.dtb ${DEPLOYDIR}
    fi

    if [ -f ${UBOOT_MACHINE}/${DPL_DEVICETREE}.dtb ]; then
        install -m 0644 ${UBOOT_MACHINE}/${DPL_DEVICETREE}.dtb ${DEPLOYDIR}
    fi
}

do_deploy:append() {

    # Note: there could be leading spaces in ${UBOOT_MACHINE} ...

    install -m 0755 -d ${DEPLOYDIR}/secure-boot/${datadir}/boot

    if [ -f ${UBOOT_MACHINE}/${DPL_DEVICETREE}.dtb ]; then
        install -m 0644 ${UBOOT_MACHINE}/${DPL_DEVICETREE}.dtb ${DEPLOYDIR}/secure-boot/${datadir}/boot
    fi
    if [ -f ${UBOOT_MACHINE}/${DPC_DEVICETREE}.dtb ]; then
        install -m 0644 ${UBOOT_MACHINE}/${DPC_DEVICETREE}.dtb ${DEPLOYDIR}/secure-boot/${datadir}/boot
    fi

    for bin in ${UBOOT_BINARIES}; do
        for m in ${UBOOT_MACHINE}; do
            install -m 0644 ${B}/${m}/${bin} ${DEPLOYDIR}/secure-boot/${datadir}/boot
        done
    done
}

COMPATIBLE_MACHINE = "(qoriq)"

FILES:${PN} += "/boot"

BBCLASSEXTEND += "nativesdk"

