# Copyright (C) 2020-2025 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>

inherit allarch

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:"
PATCHTOOL = "git"
PATCH_COMMIT_FUNCTIONS = "1"

SRC_URI += "file://rcw.patch"

# Tag: lf-6.6.52-2.2.0
# Note: the SRCREV/tag has been updated from
#       lf-6.6.36-2.0.0 to lf-6.6.52-2.2.0
SRCREV = "b77c789f6fd8d2910f7668a8e5f17b48cea3d27d"

PROVIDES += "nativesdk-${PN}"

export PYTHON = "${USRBINPATH}/python3"

python do_patch:prepend() {
    if d.getVar('PATCHTOOL') == 'git':
        srcsubdir = d.getVar('S')
        bb.process.run('git config am.threeWay true', cwd=srcsubdir)
        bb.process.run('git config am.keepcr true', cwd=srcsubdir)
        bb.process.run('git config apply.whitespace fix', cwd=srcsubdir)
        bb.process.run('git config apply.ignoreWhitespace change', cwd=srcsubdir)
}

COMPATIBLE_MACHINE = "(qoriq)"

M ?= "${MACHINE}"
M:mpxlx2160a = "mpxlx2160a"
M:mpxls1088a = "mpxls1088a"
M:mpxls1046a = "mpxls1046a"
M:mpxls1043a = "mpxls1043a"
M:mpxt1024   = "mpxt1024"
M:mpxt1042   = "mpxt1042"

do_deploy:append() {

    for boot_type in qspi sd spiflash sdcard spi nand nor; do
        if [ -d ${S}/${M}/${boot_type} ]; then
            mkdir -p ${DEPLOYDIR}/rcw/${M}/${boot_type}
            install -m 0644 ${S}/${M}/${boot_type}/*.bin ${DEPLOYDIR}/rcw/${M}/${boot_type}
            for cfg in ${S}/${M}/${boot_type}/*.cfg; do
                if [ -f ${cfg} ]; then
                    install -m 0644 ${cfg} ${DEPLOYDIR}/rcw/${M}/${boot_type}
                fi
            done
        fi
    done
}

do_deploy:append() {
    install -m 0755 -d ${DEPLOYDIR}/secure-boot/${datadir}/boot/rcw

    for boot_type in qspi sd spiflash sdcard spi nand nor; do
        if [ -d ${S}/${M}/${boot_type} ]; then
            install -m 0755 -d ${DEPLOYDIR}/secure-boot/${datadir}/boot/rcw/${boot_type}
            for rcw in ${S}/${M}/${boot_type}/*.bin; do
                install -m 0644 ${rcw} ${DEPLOYDIR}/secure-boot/${datadir}/boot/rcw/${boot_type}
            done
        fi
    done
}

FILES:${PN} += "${bindir}"

BBCLASSEXTEND += "nativesdk"

