#
# Copyright (C) 2020-2025 MicroSys Electronics GmbH
#

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:"
PATCHTOOL = "git"
PATCH_COMMIT_FUNCTIONS = "1"

SRC_URI:append = " file://atf.patch"

# Tag: lf-6.6.52-2.2.0
# Note: the SRCREV/tag has been updated from
#       lf-6.6.23-2.0.0 to lf-6.6.52-2.2.0
SRCREV = "1b27ee3edbb40ef9432c69ccaa744d1ac5d54c5d"

PROVIDES += "virtual/arm-trusted-firmware"
PROVIDES += "nativesdk-${PN}"

RCW_FOLDER:mpxls1043a = "mpxls1043a"
BOOTTYPE:mpxls1043a = "nand qspi sd"
PLATFORM:mpxls1043a = "mpxls1043a"

RCW_FOLDER:mpxls1046a = "mpxls1046a"
BOOTTYPE:mpxls1046a = "qspi sd"
PLATFORM:mpxls1046a = "mpxls1046a"

RCW_FOLDER:mpxls1088a = "mpxls1088a"
BOOTTYPE:mpxls1088a = "qspi sd"
PLATFORM:mpxls1088a = "mpxls1088a"

RCW_FOLDER:mpxlx2160a = "mpxlx2160a"
BOOTTYPE:mpxlx2160a = "flexspi_nor sd"
PLATFORM:mpxlx2160a = "mpxlx2160a"

PACKAGE_ARCH ??= "${MACHINE_ARCH}"

RCW_SUFFIX = "${@bb.utils.contains('DISTRO_FEATURES', 'secure', '_sben.bin', '.bin', d)}"

python do_patch:prepend() {
    if d.getVar('PATCHTOOL') == 'git':
        srcsubdir = d.getVar('S')
        bb.process.run('git config am.threeWay true', cwd=srcsubdir)
        bb.process.run('git config am.keepcr true', cwd=srcsubdir)
        bb.process.run('git config apply.whitespace fix', cwd=srcsubdir)
        bb.process.run('git config apply.ignoreWhitespace change', cwd=srcsubdir)
}

PLATFORM ?= "${MACHINE}"
ATF_PLAT ?= "${MACHINE}"

# The package is empty which leads to problems when
# building the image with devtool. This fix lets devtool
# build the image with modified arm-trusted-firmware.
ALLOW_EMPTY:${PN} = "1"

# Set log-level:
#       0  (LOG_LEVEL_NONE)
#       10 (LOG_LEVEL_ERROR)
#       20 (LOG_LEVEL_NOTICE)
#       30 (LOG_LEVEL_WARNING)
#       40 (LOG_LEVEL_INFO)
#       50 (LOG_LEVEL_VERBOSE)
# Default is LOG_LEVEL_INFO (40):
#EXTRA_OEMAKE += "LOG_LEVEL=40"

python() {

    debug = d.getVar("DEBUG_OPTION")
    if debug is None:
        debug = False
    else:
        if int(debug) >= 1:
            debug = True
        else:
            debug = False

    if debug:
        d.setVar("BUILD_TYPE", "debug")
}

do_compile:prepend() {

    if [ -f ${S}/localversion-microsys ]; then
        BUILD_STRING=`cat ${S}/localversion-microsys | tr -d '\r\n'`
    else
        BUILD_STRING=${DISTRO_VERSION}
    fi

    export BUILD_MESSAGE_TIMESTAMP="\"${BUILD_MESSAGE_TIMESTAMP}\""
    export BUILD_STRING="${BUILD_STRING}"
}

do_deploy:append() {
    if [ *"secure"* == ${DISTRO_FEATURES} ]; then
        install -m 0755 -d ${DEPLOYDIR}/secure-boot/${bindir}
        install -m 0755 -d ${DEPLOYDIR}/secure-boot/${datadir}/boot/csf_hdr_parser
        for tool in create_pbl byte_swap; do
            install -m 0755 ${S}/tools/nxp/create_pbl/${tool} ${DEPLOYDIR}/secure-boot/${bindir}
        done
        install -m 0755 ${S}/tools/fiptool/fiptool ${DEPLOYDIR}/secure-boot/${bindir}
        for hdr in ${S}/drivers/nxp/auth/csf_hdr_parser/input_*; do
            install -m 0644 ${hdr} ${DEPLOYDIR}/secure-boot/${datadir}/boot/csf_hdr_parser
        done
        for img in bl2.bin bl31.bin fip.bin isbc_param_*.env; do
            install -m 0644 ${B}/build/${PLATFORM}/release/${img} ${DEPLOYDIR}/secure-boot/${datadir}/boot
        done
    fi
}

FILES:${PN} += "/boot"

BBCLASSEXTEND += "nativesdk"

