# Copyright (C) 2025 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>

require conf/machine/include/qoriq-arm64.inc
require conf/machine/include/arm/arch-arm64.inc

require mpx-common.inc

IMAGE_CLASSES += "image_types_microsys"

MACHINEOVERRIDES =. "fsl-lsch3:lx2160a:mpxlx2160a:"

MACHINE_FEATURES += "optee"

# UBOOT_ENTRYPOINT: the physical start address of
# the kernel. Used as LOADADDR when building the
# kernel and as 'entry' in the FIT image.
UBOOT_ENTRYPOINT      = "0x81200000"

UBOOT_CONFIG ??= "tfa"
UBOOT_ENVBIN = "u-boot-${MACHINE}-default-environment.bin"

KERNEL_DEFCONFIG ?= "mpxlx2160a_crx08_defconfig"

SERIAL_CONSOLES ?= "115200;ttyS0 115200;ttyS1 115200;ttyAMA0"
SERIAL_CONSOLES_CHECK ?= "${SERIAL_CONSOLES}"

EXTRA_IMAGEDEPENDS += "management-complex mc-utils rcw ls2-phy ddr-phy uefi qoriq-atf inphi"
