# Copyright (C) 2025 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>

# UBOOT_DTB_LOADADDRESS: where U-Boot loads the
# kernel device tree. Used in the FIT image.
UBOOT_DTB_LOADADDRESS           ??= "0x90000000"
UBOOT_DTB_LOADADDRESS:qoriq-ppc ??= "0x1f000000"
DTB_LOAD              ??= "${UBOOT_DTB_LOADADDRESS}"

# UBOOT_ENTRYPOINT: the physical start address of
# the kernel. Used as LOADADDR when building the
# kernel and as 'entry' in the FIT image.
UBOOT_ENTRYPOINT            = "0x82000000"

# PowerPC: the address has to be same as configured in the
# Linux kernel. Check PHYSICAL_START in arch/powerpc/Kconfig.
# In this case it is 0x00000000.
UBOOT_ENTRYPOINT:qoriq-ppc  = "0x00000000"

RAMDISK_LOADADDR           ??= "0xd0000000"
RAMDISK_LOADADDR:qoriq-ppc ??= "0x30000000"

# Linux kernel parameter:
KERNEL_IMAGETYPE = "Image.gz"
KBUILD_DEFCONFIG ??= "${KERNEL_DEFCONFIG}"

SDCARD_ROOTFS ?= "${IMGDEPLOYDIR}/${IMAGE_NAME}.rootfs.ext4"
SDCARD ?= "${IMGDEPLOYDIR}/${IMAGE_NAME}.rootfs.sdcard"

# Settings for NAND flashes:
NAND_TOTAL_SIZE      ??= "0x40000000"
NAND_PAGE_SIZE       ??= "0x1000"
NAND_ERASEBLOCK_SIZE ??= "0x40000"
NAND_LEB_CNT         ??= "${@int(d.getVar('NAND_TOTAL_SIZE'), 0) // int(d.getVar('NAND_ERASEBLOCK_SIZE'), 0)}"

JFFS2_ERASEBLOCK ?= "${NAND_ERASEBLOCK_SIZE}"
MKUBIFS_ARGS ?= "--min-io-size=${NAND_PAGE_SIZE} --leb-size=${NAND_ERASEBLOCK_SIZE} --max-leb-cnt=${NAND_LEB_CNT}"
UBINIZE_ARGS ?= "--min-io-size=${NAND_PAGE_SIZE} --peb-size=${NAND_ERASEBLOCK_SIZE} --sub-page-size=${NAND_PAGE_SIZE}"

USE_VT ?= "0"
