# Copyright (C) 2024 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>

require conf/distro/fsl-qoriq.conf

IMAGE_CLASSES += "image_types_microsys"

DISTRO = "microsys-networking"
DISTRO_NAME = "MicroSys LSDK BSP"
DISTRO_VERSION = "6.8.3"
DISTRO_CODENAME = "Isar"
MAINTAINER = "Kay Potthoff <kay.potthoff@microsys.de>"

TARGET_VENDOR = "-ms"
SDK_VENDOR = "-mslsdk"
SDK_VERSION = "${DISTRO_VERSION}"

INIT_MANAGER="systemd"

RAMDISK_IMAGE_NAME = "microsys-fit-image${IMAGE_MACHINE_SUFFIX}"
SDCARD_IMAGE_NAME = "${IMAGE_BASENAME}${IMAGE_MACHINE_SUFFIX}.sdcard"
NOR_IMAGE_NAME ?= "${IMAGE_BASENAME}${IMAGE_MACHINE_SUFFIX}.nor.flash"
NAND_IMAGE_NAME ?= "${IMAGE_BASENAME}${IMAGE_MACHINE_SUFFIX}.nand.flash"
FLASH_IMAGE_NAME ?= "${NOR_IMAGE_NAME}"

IMAGE_ROOTFS_EXTRA_SPACE:append = " + 2048"

# name prefix of the kernel FIT-image:
KERNEL_FIT_IMAGE="fitImage"

# KERNEL_IMAGEDEST is the target directory in the
# rootfs, here "/boot".
# The kernel FIT-image and the flash images are stored
# there as well as the ramdisk.
KERNEL_IMAGEDEST="boot"

KERNEL_ITS = "kernel.its"
RELEASE_DIR ??= "${IMGDEPLOYDIR}/release"

INHERIT:remove		        = "create-spdx"
INHERIT_DISTRO:remove		= "create-spdx"
ERROR_QA:remove:qoriq-ppc       = "patch-status"

EFI_PREFIX          = "/"
EFIDIR              = "efi/boot"
EFI_PROVIDER        = "grub-efi"
EFI_UKI_DIR         = "efi/linux"
GRUB_BUILDIN:append = " all"
IMAGE_INSTALL:append:aarch64 = " grub-efi gnu-efi"
