# Copyright (C) 2021-2025 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>
# Modified: Sriraman Ravi <sriraman.ravi@microsys.de>

# nor_bootloader_env_offset=0x00500000
# nor_secureboot_headers_offset=0x00600000
# nor_ddr_phy_fw_offset=0x00800000
# nor_fuse_headers_offset=0x00880000
# nor_dp_firmware_offset=0x00940000
# nor_phy_firmware_offset=0x00980000
# nor_uboot_scr_offset=0x009C0000
# nor_dpaa2_mc_fw_offset=0x00A00000
# nor_dpaa2_mc_dpl_offset=0x00D00000
# nor_dpaa2_mc_dpc_offset=0x00E00000
# nor_device_tree_offset=0x00F00000
# nor_kernel_offset=0x01000000
# nor_kernelitb_offset=0x01000000
# nor_initrdrfs_offset=0x01100000

RCW_OFFSET         = "0x0"
BOOTLOADER_OFFSET  = "0x1000"
FIP_OFFSET         = "0x100000"
FMAN_UCODE_OFFSET  = "0x900000"
QE_FIRMWARE_OFFSET = "0x940000"

FIP_UBOOT = "${@bb.utils.contains('DISTRO_FEATURES', 'secure', \
				'fip_uboot_sec.bin', \
				'fip_uboot.bin', d)}"

BL2_FLASH_PBL = "bl2_qspi.pbl"
BL2_FLASH_PBL:mpxls1088a = "${@bb.utils.contains('DISTRO_FEATURES', 'secure', \
								'bl2_qspi_sec.pbl', \
								'bl2_qspi.pbl', d)}"

BL2_FLASH_PBL:mpxlx2160a = "${@bb.utils.contains('DISTRO_FEATURES', 'secure', \
								'bl2_flexspi_nor_sec.pbl', \
								'bl2_flexspi_nor.pbl', d)}"

BL2_SD_PBL = "${@bb.utils.contains('DISTRO_FEATURES', 'secure', \
								'bl2_sd_sec.pbl', \
								'bl2_sd.pbl', d)}"

def get_uboot_env(d):
    import glob
    deploy_dir = d.getVar('DEPLOY_DIR_IMAGE')
    machine = d.getVar('MACHINE')
    u_boot_envs = [e for e in glob.glob(os.path.join(deploy_dir, 'u-boot-*-initial-env-'+machine+'-*')) if not os.path.islink(e)]
    if len(u_boot_envs) > 0:
       return u_boot_envs[0]
    return "/dev/zero"

get_extra_space() {
    # Additional size for the root FS:
    # Note: IMAGE_ROOTFS_EXTRA_SPACE contains extra space in KiB
    extra_space=$(expr \( 0${IMAGE_ROOTFS_EXTRA_SPACE} \) \* 1024)
    add_size=4\*1024\*1024+${extra_space}
    echo $(expr ${add_size})
}

generate_its() {
    :
}

generate_mmc_its_ls104xa() {

    its_file=$1
    sdcard=$2
    part_img=$3
    part_start=$4
    fman_ucode=$5
    qe_ucode=$6

    # Additional size of the root FS:
    add_size=$(get_extra_space)

    itsgen --file ${its_file} --binman ${sdcard} \
            --pad 0x00 --align 512 \
            --etype ${part_img}:name=part_table:offset=0 \
            --etype ${DEPLOY_DIR_IMAGE}/atf/${BL2_SD_PBL}:name=atf_bl2:offset=${BOOTLOADER_OFFSET} \
            --etype ${DEPLOY_DIR_IMAGE}/atf/${FIP_UBOOT}:name=fip_uboot:offset=${FIP_OFFSET} \
            --etype ${fman_ucode}:name=fman:offset=${FMAN_UCODE_OFFSET} \
            --etype ${qe_ucode}:name=qe:offset=${QE_FIRMWARE_OFFSET} \
            --etype ${SDCARD_ROOTFS}:name=rootfs:offset=${part_start}\*512:align-end=512:add-size=${add_size}
}

generate_its:mpxls1043a() {

    fman_ucode=${DEPLOY_DIR_IMAGE}/fsl_fman_ucode_ls10\\*.bin
    qe_ucode=${DEPLOY_DIR_IMAGE}/boot/iram_Type_A_LS1021a\\*.bin

    its_file=$1
    sdcard=$2
    part_img=$3
    part_start=$4

    generate_mmc_its_ls104xa ${its_file} ${sdcard} ${part_img} ${part_start} ${fman_ucode} ${qe_ucode}
}

generate_its:mpxls1046a() {

    fman_ucode=${DEPLOY_DIR_IMAGE}/fsl_fman_ucode_ls10\\*.bin
    qe_ucode=${DEPLOY_DIR_IMAGE}/boot/iram_Type_A_LS1021a\\*.bin

    its_file=$1
    sdcard=$2
    part_img=$3
    part_start=$4

    generate_mmc_its_ls104xa ${its_file} ${sdcard} ${part_img} ${part_start} ${fman_ucode} ${qe_ucode}
}

generate_its:mpxls1088a() {

    its_file=$1
    sdcard=$2
    part_img=$3
    part_start=$4

    # Additional size of the root FS:
    add_size=$(get_extra_space)

    itsgen --file ${its_file} --binman ${sdcard} \
            --pad 0x00 --align 512 \
            --etype ${part_img}:name=part_table:offset=0 \
            --etype ${DEPLOY_DIR_IMAGE}/atf/${BL2_SD_PBL}:name=atf_bl2:offset=${BOOTLOADER_OFFSET} \
            --etype ${DEPLOY_DIR_IMAGE}/atf/${FIP_UBOOT}:name=fip_uboot:offset=${FIP_OFFSET} \
            --etype ${DEPLOY_DIR_IMAGE}/mc_app/mc.itb:name=mc:offset=0xa00000 \
            --etype ${DEPLOY_DIR_IMAGE}/${DPL_BLOB}:name=dpl:offset=0xd00000 \
            --etype ${DEPLOY_DIR_IMAGE}/${DPC_BLOB}:name=dpc:offset=0xe00000 \
            --etype ${SDCARD_ROOTFS}:name=rootfs:offset=${part_start}\*512:align-end=512:add-size=${add_size}
}

generate_mmc_its_t10xx() {

    its_file=$1
    sdcard=$2
    part_img=$3
    part_start=$4
    fman_ucode=$5
    qe_ucode=$6

    # Additional size of the root FS:
    add_size=$(get_extra_space)

    itsgen --file ${its_file} --binman ${sdcard} \
            --pad 0x00 --align 512 \
            --etype ${part_img}:name=part_table:offset=0 \
            --etype ${DEPLOY_DIR_IMAGE}/u-boot.bin-sdcard:name=fip_uboot:offset=${BOOTLOADER_OFFSET} \
            --etype ${fman_ucode}:name=fman:offset=0x140000 \
            --etype ${qe_ucode}:name=qe:offset=0x150000 \
            --etype ${SDCARD_ROOTFS}:name=rootfs:offset=${part_start}\*512:align-end=512:add-size=${add_size}
}

generate_its:mpxt1024() {

    fman_ucode=${DEPLOY_DIR_IMAGE}/fsl_fman_ucode_t102\\*.bin
    qe_ucode=${DEPLOY_DIR_IMAGE}/boot/iram_Type_A_T1024\\*.bin

    its_file=$1
    sdcard=$2
    part_img=$3
    part_start=$4

    generate_mmc_its_t10xx ${its_file} ${sdcard} ${part_img} ${part_start} ${fman_ucode} ${qe_ucode}
}

generate_its:mpxt1042() {

    fman_ucode=${DEPLOY_DIR_IMAGE}/fsl_fman_ucode_t104\\*.bin
    qe_ucode=${DEPLOY_DIR_IMAGE}/boot/iram_Type_A_T104\\*.bin

    its_file=$1
    sdcard=$2
    part_img=$3
    part_start=$4

    generate_mmc_its_t10xx ${its_file} ${sdcard} ${part_img} ${part_start} ${fman_ucode} ${qe_ucode}
}

generate_its:mpxlx2160a() {

    its_file=$1
    sdcard=$2
    part_img=$3
    part_start=$4

    # Additional size of the root FS:
    add_size=$(get_extra_space)

    itsgen --file ${its_file} --binman ${sdcard} \
            --pad 0x00 --align 512 \
            --etype ${part_img}:name=part_table:offset=0 \
            --etype ${DEPLOY_DIR_IMAGE}/atf/${BL2_SD_PBL}:name=atf_bl2:offset=${BOOTLOADER_OFFSET} \
            --etype ${DEPLOY_DIR_IMAGE}/atf/${FIP_UBOOT}:name=fip_uboot:offset=${FIP_OFFSET} \
            --etype ${DEPLOY_DIR_IMAGE}/ddr-phy/fip_ddr_all.bin:name=ddr_phy:offset=0x800000 \
            --etype ${DEPLOY_DIR_IMAGE}/mc_app/mc.itb:name=mc:offset=0xa00000 \
            --etype ${DEPLOY_DIR_IMAGE}/${DPL_BLOB}:name=dpl:offset=0xd00000 \
            --etype ${DEPLOY_DIR_IMAGE}/${DPC_BLOB}:name=dpc:offset=0xe00000 \
            --etype ${SDCARD_ROOTFS}:name=rootfs:offset=${part_start}\*512:align-end=512:add-size=${add_size}
}

generate_sdcard_image() {

    sdcard=$1
    outdir=${IMGDEPLOYDIR}/sdcard

    # Start sector on SD-card (multiple of 2048):
    part_start=32768

    part_img=${B}/part-$$.img
    its_file=${B}/sdcard-$$.its
    dtb_file=${B}/sdcard-$$.dtb

    dd if=/dev/zero of=${part_img} bs=512 count=0 seek=2
    parted --script ${part_img} mklabel msdos

    generate_its ${its_file} ${sdcard} ${part_img} ${part_start}

    dtc --out ${dtb_file} --in-format dts ${its_file}

    ${BINMAN} --debug build --no-expanded \
        --dt ${dtb_file} \
        --outdir ${outdir}

    rm -f ${outdir}/image.map ${outdir}/u-boot.dtb.out

    parted --script ${outdir}/${sdcard} mkpart primary ext4 ${part_start}s 100%

    ln --force --symbolic --no-dereference  sdcard/${sdcard} ${IMGDEPLOYDIR}/${sdcard}

    mkdir --parents ${RELEASE_DIR}

    img_path=$(realpath --relative-to=${RELEASE_DIR} ${DEPLOY_DIR}/sdcard)

    ln --force --symbolic --no-dereference ${img_path}/${sdcard} ${RELEASE_DIR}/${sdcard}
}

IMAGE_CMD:tfa-sdcard () {

    generate_sdcard_image ${SDCARD_IMAGE_NAME}

}

IMAGE_CMD:ppc-sdcard () {

    generate_sdcard_image ${SDCARD_IMAGE_NAME}

}

IMAGE_TYPEDEP:tfa-sdcard:append = " ${@d.getVar('SDCARD_ROOTFS', 1).split('.')[-1]}"

#
# RAMDISK
#

FDT_BLOB = "${@' --fdt '.join([os.path.join(d.getVar('DEPLOY_DIR_IMAGE'), os.path.basename(dtb)) for dtb in d.getVar('KERNEL_DEVICETREE').split()])}"
RAMDISK_LOADADDR ??= "0xd0000000"

IMAGE_CMD:ramdisk() {

    mkdir --parents ${IMGDEPLOYDIR}/ramdisk

    itsgen --file ${B}/ramdisk.its \
           --kernel ${DEPLOY_DIR_IMAGE}/${KERNEL_IMAGETYPE}:entry=${UBOOT_ENTRYPOINT} \
           --fdt ${FDT_BLOB} \
           --ramdisk ${IMGDEPLOYDIR}/${IMAGE_NAME}.ext4.gz:load=${RAMDISK_LOADADDR}

    mkimage --fit ${B}/ramdisk.its ${IMGDEPLOYDIR}/ramdisk/${RAMDISK_IMAGE_NAME}.ramdisk

    ln --force --symbolic --no-dereference ramdisk/${RAMDISK_IMAGE_NAME}.ramdisk ${IMGDEPLOYDIR}/${RAMDISK_IMAGE_NAME}.ramdisk

    mkdir --parents ${RELEASE_DIR}

    img_path=$(realpath --relative-to=${RELEASE_DIR} ${DEPLOY_DIR}/ramdisk)

    ln --force --symbolic --no-dereference ${img_path}/${RAMDISK_IMAGE_NAME}.ramdisk ${RELEASE_DIR}/${RAMDISK_IMAGE_NAME}.ramdisk
}

#
# FLASH
#

DPC_BLOB = "${@os.path.basename(d.getVar('DPC_DEVICETREE') or 'dpc')+'.dtb'}"
DPL_BLOB = "${@os.path.basename(d.getVar('DPL_DEVICETREE') or 'dpl')+'.dtb'}"

compile_flash_image() {

    image_name=$1

    link_suffix=$(echo ${image_name} | cut --delimiter=. --field=1 --complement)

    dtc ${B}/flash.its --out ${B}/flash.dtb

    ${BINMAN} build --dt ${B}/flash.dtb --outdir ${IMGDEPLOYDIR}/flash

    rm -f ${IMGDEPLOYDIR}/flash/image.map ${IMGDEPLOYDIR}/flash/u-boot.dtb.out

    ln --force --symbolic --no-dereference flash/${image_name} ${IMGDEPLOYDIR}/${image_name}

    install -d ${IMAGE_ROOTFS}/${KERNEL_IMAGEDEST}
    install -m 0644 ${IMGDEPLOYDIR}/flash/${image_name} ${IMAGE_ROOTFS}/${KERNEL_IMAGEDEST}

    ln --force --symbolic --no-dereference ${image_name} ${IMAGE_ROOTFS}/boot/microsys-image.${link_suffix}

    mkdir --parents ${RELEASE_DIR}
    ln --force --symbolic --no-dereference ${DEPLOY_DIR}/flash/${image_name} ${RELEASE_DIR}/microsys-image.${link_suffix}
}

IMAGE_CMD:flash() {
    :
}

IMAGE_CMD:flash:mpxlx2160a() {

    itsgen --file ${B}/flash.its --binman ${NOR_IMAGE_NAME} \
        --pad 0xff --fill 0xff \
        --etype ${DEPLOY_DIR_IMAGE}/atf/${BL2_FLASH_PBL}:name=rcw:offset=${RCW_OFFSET} \
        --etype ${DEPLOY_DIR_IMAGE}/atf/${FIP_UBOOT}:name=uboot_xspi:offset=${FIP_OFFSET} \
        --etype ${DEPLOY_DIR_IMAGE}/ddr-phy/fip_ddr_all.bin:name=ddr_phy:offset=0x800000 \
        --etype ${DEPLOY_DIR_IMAGE}/mc_app/mc.itb:name=mc:offset=0xa00000 \
        --etype ${DEPLOY_DIR_IMAGE}/${DPL_BLOB}:name=dpl:offset=0xd00000 \
        --etype ${DEPLOY_DIR_IMAGE}/${DPC_BLOB}:name=dpc:offset=0xe00000

    compile_flash_image ${NOR_IMAGE_NAME}
}

IMAGE_CMD:flash:mpxls1088a() {

    itsgen --file ${B}/flash.its --binman ${NOR_IMAGE_NAME} \
        --pad 0xff --fill 0xff \
        --etype ${DEPLOY_DIR_IMAGE}/atf/${BL2_FLASH_PBL}:name=rcw:offset=${RCW_OFFSET} \
        --etype ${DEPLOY_DIR_IMAGE}/atf/${FIP_UBOOT}:name=uboot_qspi:offset=${FIP_OFFSET} \
        --etype ${DEPLOY_DIR_IMAGE}/mc_app/mc.itb:name=mc:offset=0xa00000 \
        --etype ${DEPLOY_DIR_IMAGE}/${DPL_BLOB}:name=dpl:offset=0xd00000 \
        --etype ${DEPLOY_DIR_IMAGE}/${DPC_BLOB}:name=dpc:offset=0xe00000

    compile_flash_image ${NOR_IMAGE_NAME}
}

generate_flash_its_ls104xa() {

    image_name=$1
    fman_ucode=$2
    qe_ucode=$3
    flash_type=$4

    itsgen --file ${B}/flash.its --binman ${image_name} \
        --pad 0xff --fill 0xff \
        --etype ${DEPLOY_DIR_IMAGE}/atf/bl2_${flash_type}.pbl:name=rcw:offset=${RCW_OFFSET} \
        --etype ${DEPLOY_DIR_IMAGE}/atf/${FIP_UBOOT}:name=uboot_qspi:offset=${FIP_OFFSET} \
        --etype ${fman_ucode}:name=fman:offset=${FMAN_UCODE_OFFSET} \
        --etype ${qe_ucode}:name=qe:offset=${QE_FIRMWARE_OFFSET}
}

generate_flash_its_t10xx() {

    image_name=$1
    fman_ucode=$2
    qe_ucode=$3
    flash_type=$4

    itsgen --file ${B}/flash.its --binman ${image_name} \
        --pad 0xff --fill 0xff \
        --etype ${DEPLOY_DIR_IMAGE}/u-boot.bin-${flash_type}:name=fip_uboot:offset=${RCW_OFFSET} \
        --etype ${fman_ucode}:name=fman:offset=${FMAN_UCODE_OFFSET} \
        --etype ${qe_ucode}:name=qe:offset=${QE_FIRMWARE_OFFSET}
}

IMAGE_CMD:flash:mpxls1043a() {

    fman_ucode=${DEPLOY_DIR_IMAGE}/fsl_fman_ucode_ls10\\*.bin
    qe_ucode=${DEPLOY_DIR_IMAGE}/boot/iram_Type_A_LS1021a\\*.bin

    generate_flash_its_ls104xa ${NOR_IMAGE_NAME} ${fman_ucode} ${qe_ucode} qspi
    compile_flash_image ${NOR_IMAGE_NAME}

    generate_flash_its_ls104xa ${NAND_IMAGE_NAME} ${fman_ucode} ${qe_ucode} nand
    compile_flash_image ${NAND_IMAGE_NAME}
}

IMAGE_CMD:flash:mpxls1046a() {

    fman_ucode=${DEPLOY_DIR_IMAGE}/fsl_fman_ucode_ls10\\*.bin
    qe_ucode=${DEPLOY_DIR_IMAGE}/boot/iram_Type_A_LS1021a\\*.bin

    generate_flash_its_ls104xa ${NOR_IMAGE_NAME} ${fman_ucode} ${qe_ucode} qspi
    compile_flash_image ${NOR_IMAGE_NAME}
}

IMAGE_CMD:flash:mpxt1024() {

    fman_ucode=${DEPLOY_DIR_IMAGE}/fsl_fman_ucode_t1024\\*.bin
    qe_ucode=${DEPLOY_DIR_IMAGE}/boot/iram_Type_A_T1024\\*.bin

    generate_flash_its_t10xx ${NOR_IMAGE_NAME} ${fman_ucode} ${qe_ucode} spi
    compile_flash_image ${NOR_IMAGE_NAME}

    generate_flash_its_t10xx ${NAND_IMAGE_NAME} ${fman_ucode} ${qe_ucode} nand
    compile_flash_image ${NAND_IMAGE_NAME}
}

IMAGE_CMD:flash:mpxt1042() {

    fman_ucode=${DEPLOY_DIR_IMAGE}/fsl_fman_ucode_t1040\\*.bin
    qe_ucode=${DEPLOY_DIR_IMAGE}/boot/iram_Type_A_T1040\\*.bin

    generate_flash_its_t10xx ${NOR_IMAGE_NAME} ${fman_ucode} ${qe_ucode} spi
    compile_flash_image ${NOR_IMAGE_NAME}
}

EXPORT_FUNCTIONS get_uboot_env
