Copyright (C) 2020-2025 MicroSys Electronics GmbH

# Release Notes for MPXLS10xxA/MPXT10xx & MPXLX2160A Yocto Layer

## Supported Platforms

### MPXLS1043A

| Machine                     | Description                            |
|-----------------------------|----------------------------------------|
| mpxls1043acrx05             | MPXLS1043A Carrier CRX05               |
| mpxls1043acrx05-c1000       | MPXLS1043A (1GHz) Carrier CRX05        |
| mpxls1043acrx09-adx03       | MPXLS1043A Carrier CRX09, ADX03        |
| mpxls1043acrx09-adx03-c1000 | MPXLS1043A (1GHz) Carrier CRX09, ADX03 |

### MPXLS1046A

| Machine                     | Description                                 |
|-----------------------------|---------------------------------------------|
| mpxls1046acrx05             | MPXLS1046A Carrier CRX05                    |
| mpxls1046acrx06-2xtsn       | MPXLS1046A Carrier CRX06, TSN               |
| mpxls1046acrx09-adx03       | MPXLS1046A Carrier CRX09, ADX03             |
| mpxls1046acrx09r2-adx02r2   | MPXLS1046A Carrier CRX09 Rev.2, ADX02 Rev.2 |
| mpxls1046acrx09r2-adx03r2   | MPXLS1046A Carrier CRX09 Rev.2, ADX03 Rev.2 |

### MPXLS1088A

| Machine                     | Description                                 |
|-----------------------------|---------------------------------------------|
| mpxls1088acrx05             | MPXLS1088A Carrier CRX05                    |
| mpxls1088acrx06-2xtsn       | MPXLS1088A Carrier CRX06, TSN               |
| mpxls1088acrx09-adx01       | MPXLS1088A Carrier CRX09, ADX01             |
| mpxls1088acrx09-adx02       | MPXLS1088A Carrier CRX09, ADX02             |
| mpxls1088acrx09-adx03       | MPXLS1088A Carrier CRX09, ADX03             |
| mpxls1088acrx09r2-adx02r2   | MPXLS1088A Carrier CRX09 Rev.2, ADX02 Rev.2 |
| mpxls1088acrx09r2-adx03r2   | MPXLS1088A Carrier CRX09 Rev.2, ADX03 Rev.2 |
| mpxls1088acrx09r2-adx03r3   | MPXLS1088A Carrier CRX09 Rev.2, ADX03 Rev.3 |

### MPXLX2160A

| Machine                     | Description                            |
|-----------------------------|----------------------------------------|
| mpxlx2160acrx08             | MPXLX2160A Carrier CRX08               |
| mpxlx2160aacu               | MPXLX2160A ACU Platform                |

### MPXT1024

| Machine                     | Description                            |
|-----------------------------|----------------------------------------|
| mpxt1024crx05               | MPXT1024 Carrier CRX05 (64-bit)        |

### MPXT1042

| Machine                     | Description                            |
|-----------------------------|----------------------------------------|
| mpxt1042crx05               | MPXT1042 Carrier CRX05 (64-bit)        |

## Known Limitations

- MPXLX2160A:
   	- DPMAC5 25G SFP not yet supported.
	- Currently USB 3 not supported

- MPXLS1088A:
    - XFI/10GBase-R: no auto-negotiation -- only 10Gb speed supported

## Yocto

Supported build hosts:

- Fedora 39

A complete and actual list can be found in the poky distribution at
`poky/meta-poky/conf/distro/poky.conf`
and then check the variable SANITY_TESTED_DISTROS.

## Change History

### 6.8.3: 2026-01-07

Based on LSDK-Scarthgap

Fixed NAND flashes sometimes not detected.

- ATF 2.10.0 6.8.2
- U-Boot 2024.04 6.8.3
- Linux 6.6.52 6.8.3
- RCW 6.6.52-2.2.0 6.8

### 6.8.2: 2025-12-08

Based on LSDK-Scarthgap

Added support for MPXLS1088A Carrier CRX09 Rev.2, ADX03 Rev.3

- ATF 2.10.0 6.8.2
- U-Boot 2024.04 6.8.2
- Linux 6.6.52 6.8.2
- RCW 6.6.52-2.2.0 6.8

### 6.8.1: 2025-11-21

Based on LSDK-Scarthgap

- ATF 2.10.0 6.5.2
- U-Boot 2024.04 6.8
- Linux 6.6.52 6.8.1
    - MPXLX2160A/ACU: fixed UART1 setup to run in default mode
- RCW 6.6.52-2.2.0 6.8

### 6.8: 2025-11-18

Based on LSDK-Scarthgap

- ATF 2.10.0 6.5.2
- U-Boot 2024.04 6.8
    - MPXLS1088A: secure boot configuration
- Linux 6.6.52 6.8
    - MPXLX2160A/ACU: fixed mode of UART1: RS485 set to SBSA-mode
- RCW 6.6.52-2.2.0 6.8
    - MPXLS1088A: secure boot configuration

### 6.7: 2025-11-12

Based on LSDK-Scarthgap

- ATF 2.10.0 6.5.2
- U-Boot 2024.04 6.7
    - MPXLX2160A: watchdog enabled
- Linux 6.6.52 6.7
    - MPXLX2160A: watchdog enabled
- RCW 6.6.52-2.2.0 6.6

### 6.6: 2025-11-05

Based on LSDK-Scarthgap

Support for MPXLS1046A/CRX09R2/ADX02R2, MPXLS1046A/CRX09R2/ADX03R2
and MPXLS1088A/CRX09R2/ADX03R2.

- ATF 2.10.0 6.5.2
- U-Boot 2024.04 6.6
- Linux 6.6.52 6.6
    - cgroups v2 enabled per default
- RCW 6.6.52-2.2.0 6.6

### 6.5.2: 2025-09-30

Based on LSDK-Scarthgap

Support for MPXT1024 and MPXLS1043A with NAND boot.

- ATF 2.10.0 6.5.2
    - fixed DDR configuration of MPXLS1043A
- U-Boot 2024.04 6.5.2
    - switched off unused clocks
- Linux 6.6.52 6.5.2
    - fixed UART setup for MPXLX2160A/ACU
- RCW 6.6.52-2.2.0 6.5.2
    - Overclocking of cores 0-5 on MPXLX2160A/ACU to 2.2GHz
- Enabled CGROUPS V2 in systemd per default

### 6.5.1: 2025-08-28

Based on LSDK-Scarthgap

Support for MPXT1042 with carrier CRX05.

- ATF 2.10.0 6.2
- U-Boot 2024.04 6.5.1
- Linux 6.6.52 6.5.1
- RCW 6.1.55-2.2.0 6.5.1

### 6.5: 2025-07-02

Based on LSDK-Scarthgap

Support for MPXT1024 with carrier CRX05.

- ATF 2.10.0 6.2
- U-Boot 2024.04 6.5
- Linux 6.6.52 6.5
- RCW 6.1.55-2.2.0 6.5

### 6.4.1: 2025-06-04

Based on LSDK-Scarthgap

- ATF 2.10.0 6.2
- U-Boot 2024.04 6.4.1
    - devicetree fixes for CRX05
- Linux 6.6.52 6.4.1
    - devicetree fixes for CRX05
- RCW 6.1.55-2.2.0 6.4

### 6.4: 2025-05-20

Based on LSDK-Scarthgap

- ATF 2.10.0 6.2
- U-Boot 2024.04 6.4
- Linux 6.6.52 6.4
- RCW 6.1.55-2.2.0 6.4

### 6.3: 2025-05-09

Based on LSDK-Scarthgap

- ATF 2.10.0 6.2
- U-Boot 2024.04 6.3
- Linux 6.6.52 6.3
- RCW 6.1.55-2.2.0 6.3

### 6.2: 2025-05-05

Based on LSDK-Scarthgap

- ATF 2.10.0 6.2
- U-Boot 2024.04 6.2
- Linux 6.6.52 6.2
- RCW 6.1.55-2.2.0 6.2

### 6.1: 2025-04-04

Based on LSDK-Scarthgap

- ATF 2.10.0 6.0
- U-Boot 2024.04 6.1
- Linux 6.6.52 6.1
- RCW 6.1.55-2.2.0 6.1

### 5.9.2: 2024-12-02

Based on LSDK-kirkstone.

- ATF 2.6 5.9.1
    - DRAM detection for MPXLS1046A
- U-Boot 2022.04 5.9.1
- Linux 5.15.71 5.9.2
    - corrected I2C connection of TUSB8041
- RCW 5.15.32-2.0.0 5.8

### 5.9.1: 2024-11-14

Based on LSDK-kirkstone.

- ATF 2.6 5.9
- U-Boot 2022.04 5.9.1
    - fixed default environment when booting from
      QSPI flash
- Linux 5.15.71 5.8
- RCW 5.15.32-2.0.0 5.8

### 5.9: 2024-11-04

Based on LSDK-kirkstone.

- ATF 2.6 5.9
    - Fixed: added fix for Errata A009663 for LS1043A
- U-Boot 2022.04 5.8
- Linux 5.15.71 5.8
- RCW 5.15.32-2.0.0 5.8

### 5.8: 2024-09-30

Based on LSDK-kirkstone.

- ATF 2.6 5.8
- U-Boot 2022.04 5.8
- Linux 5.15.71 5.8
- RCW 5.15.32-2.0.0 5.8

- Added new machines
	- mpxls1088ram8gb2nandcrx5: MPXLS1088A with 8GB RAM, 2GB NAND, Carrier CRX05 and 1.6 GHZ core CPU Frequency
	- mpxls1088ram8gb2nandcrx6: MPXLS1088A with 8GB RAM, 2GB NAND, Carrier CRX06, 2xXFI, TSN and 1.6 GHZ core CPU Frequency

### 5.7: 2024-01-07

Based on LSDK-kirkstone.

- ATF 2.6 5.6
- U-Boot 2022.04 5.7
- Linux 5.15.71 5.7
- RCW 5.15.32-2.0.0 5.7

- Support for MPXLX2160/MPXLS1088/MPXLS1046/MPXLS1043/MPXLS1028 platform
	- added mpxls1046crx06qsgmii machine
	- Updated CRX08 USB Hub configuration, support for SMBus and I2C mode

### 5.6: 2024-21-05

Based on LSDK-kirkstone.

- Support for MPXLX2160/MPXLS1088/MPXLS1046/MPXLS1043/MPXLS1028 platform
	- ATF 2.6 5.6
	- U-Boot 2022.04 5.6
	- Linux 5.15.71 5.6
	- RCW 5.15.32-2.0.0 5.6

### 5.5: 2024-04-05

Based on LSDK-kirkstone.

- Support for MPXLS1088/MPXLS1046/MPXLS1043/MPXLS1028 platform
	- ATF 2.6 5.5
	- U-Boot 2022.04 5.5
	- Linux 5.15.71 5.5

- Support for MPXLX2160 platform
	- ATF 2.4 5.0
	- U-Boot 2021.04 5.5
	- Linux 5.15.71 5.5

### 5.4: 2024-03-07

Based on LSDK-kirkstone.

- ATF 2.6 5.4
- U-Boot 2022.04 5.4
- Linux 5.15.71 5.4

- Support for MPXLS1088/MPXLS1046/MPXLS1043 platform

### 5.3: 2024-02-29

Based on LSDK-kirkstone.

- ATF 2.6 5.3
- U-Boot 2022.04 5.3
- Linux 5.15.71 5.3

- Support for MPXLS1046 platform

### 5.2: 2024-02-20

Based on LSDK-kirkstone.

- ATF 2.6 5.2
- U-Boot 2022.04 5.2
- Linux 5.15.71 5.2

### 5.1: 2024-02-14

Based on LSDK-kirkstone.

- ATF 2.6 5.1
- U-Boot 2022.04 5.1
- Linux 5.15.71 5.1

### 5.0: 2024-01-29

Based on LSDK-kirkstone.

- ATF 2.4 5.0.1
- U-Boot 2021.04 5.0.1
- Linux 5.15.71 5.0

### 4.0.8: 2024-01-10

Based on LSDK-21.08.

- ATF 2.4 4.0.6
- U-Boot 2021.04 4.0.6
- Linux 5.10.72 4.0.8
    - fixed XFI support
    - fixed TSN support

### 4.0.7: 2023-11-28

Updated README, migration from CodeAurora Forum to GitHub

- ATF 2.4 4.0.6
- U-Boot 2021.04 4.0.6
- Linux 5.10.72 4.0.6

### 4.0.6: 2023-11-27

- Added Support for Machine mpxlx2160aacu

### 4.0.3: 2022-05-03

Updated Install script

### 4.0.2: 2022-05-03

Fixed build for mpxls1043 machines

### 4.0.1: 2022-04-21

Replaced machine mpxls1043crx05 with the following added machines:

- mpxls1043ac1000msatacrx05
- mpxls1043ac1000pciecrx05
- mpxls1043ac1600msatacrx05
- mpxls1043ac1600pciecrx05

### 4.0: 2022-03-28

- ATF 2.4
- U-Boot 2021.04
- Linux 5.10.72
- fixed network for MPXLS1088A

### 3.3: 2021-11-30

- hailo: Updated Hailo External Source Path


### 3.2: 2021-11-29

- microsys-image-networking: Updated ramdisk image dependencies

### 3.1: 2021-11-17

- Added Support for MicroSys-Hailo AI Platform
- Added Machine for MicroSys-Hailo AI Platform : mpxlx2160acrx08ai

### 3.0: 2021-10-25

- Ported to LSDK-21.08 release
- U-Boot 2021.04
- Linux kernel 5.10-35

### 2.3.9: 2021-10-11

- Yocto: Updated default serdes config for mpxls1043 to 0x3358 with msata
- linux: mpxls1043: Enabled USB controllers in device tree

### 2.3.8: 2021-09-16

- U-Boot: Added Support for LX2160 CPU without CAN-FD functionality
- This fixes the issue where PCIE driver tries to call pcie-layerscape-gen4
  feature in linux Kernel due which pcie devices are not found in Linux

### 2.3.7: 2021-09-10

- rootfs: Added udev networking rules for fsl dpaa.

### 2.3.6: 2021-08-25

- rootfs: Added udev networking rules for fsl dpaa.

### 2.3.5: 2021-08-03

- mpxls1088: removed unused mac interfaces from device tree.

### 2.3.4: 2021-08-02

- mpxls10xx: dts: fixed wrong remote temperature shown
- mmc: The clock rate of the SD-card was not correctly set. For MPXLS1046A the divider has to be 1.

### 2.3.3: 2021-07-07

- Fixed large ramdisk image size

### 2.3.2: 2021-07-01

- MC Firmware Update 10.24.0
- Fixed Yocto - ramdisk build issue

### 2.3.1: 2021-06-18

- Adapted support for MPXLS1088:CRX06:2xQSGMII for LSDK-20.12

### 2.3: 2021-03-04

- Ported to LSDK-20.12 release
- U-Boot 2019.10
- Linux kernel 5.4
- Machine MPX-LX2160A with CRX08 Support

### 2.2: 2020-07-29

- Added support for MPXLS1088:CRX06:2xQSGMII

### 2.2: 2020-05-26

- Ported to LSDK-20.04 release
- U-Boot 2019.10
- Linux kernel 5.4

### 2.1: 2019-12-16

- Version 2.1
- Ported to LSDK-19.09 release
- Added Arm Trusted Firmware Support.
- RCW Update: Added PBI values for PCIE and other necessary Erratum.
- RCW Update: RCW[IRQ_EXT] has been set to 0 in order to use the External IRQs.
- RCW Update: Added RCW for NAND Boot.
- U-Boot for SD-card and QSPI boot based on version 2019.06.
- Linux kernel based on kernel version 4.19.68.
- Added Ramdisk Image Feature.

### 2.0: 2019-07-19

- Version 2.0
- U-Boot for SD-card boot based on version 2018.09
- Linux kernel based on kernel version 4.19
- Update uboot_firmware command to update QSPI, NAND u-boot, ppa firmware and fsl-fman-ucode

### 1.4: 2020-01-29

- Ported to build with Yocto 'zeus' release
- Fixed missing network interface 'eno3' in RCW
- Fixed no SerDes link between QSGMII PHY and TSN switch

### 1.3: 2019-11-29

- Fixed problems with tsntool
- Enabled TSN switch support in kernel configuration

### 1.2: 2019-11-07
---------------

- Added tsntool 0.3 for managing the TSN switch
- Switched to TFA-boot using ATF bootloader
- Updated to U-Boot 2019.04 and Linux kernel 4.19.68 according to LSDK-19.09 version
- Support for 1500MHz core frequency in RCW

### 1.1: 2019-07-29

- Fixed Yocto build issue when patching the Linux kernel.

### 1.0: 2019-05-22

- Initial version
- U-Boot for SD-card boot based on version 2018.09
- Linux kernel based on kernel version 4.14
- No support for GPU GC7000. This will be fixed in future.
- No support for managing the on-chip TSN switch. This will be fixed in future.
- Firmware for DisplayPort is not automatically installed into the root filesystem. Please check README-microsys.md how to install it manually. This will be fixed in future.
