Copyright (C) 2020-2025 MicroSys Electronics GmbH

# Yocto Build Setup

This text describes how to create a Yocto build environment for the MicroSys Layerscape family.
All machines listed in the file "ReleaseNotes.md" can be built by setting the corresponding environment. See also
[step 7](###Steps).
e.g.:
```
$ . setup-env -m mpxls1088acrx09-adx03
```
prepares for MPXLS1088A; Carrier CRX09/ADX03 in directory build_mpxls1088acrx09-adx03

## Download and Clone NXP's Yocto Repository

### Presumptions

LSDK-scarthgap is based on Yocto Poky 5.0.

You need a build host that is supported by this Yocto release.

Please check the documentation at
[System Requirements Poky 5.0](https://docs.yoctoproject.org/5.0.6/ref-manual/system-requirements.html).

### Steps

1. Install 'repo' if not already done:
```
# curl https://commondatastorage.googleapis.com/git-repo-downloads/repo > /usr/local/bin/repo
# chmod a+x /usr/local/bin/repo
```
2. Create and go to a directory of your choice, further referred to as `workspace` directory

3. Install the LSDK and fix the broken links

NXP has moved its repositories from source.codeaurora.org to github.com/nxp-qoriq. For a BSP that has been released
before all broken links in the recipes need to be fixed to point to their new locations. Additionally, there are
repositories where the branch "master" has been renamed to "main". Theses URIs need to be fixed, too.

MicroSys provides a tool called "migrate_repo.py" that parses through the BSP sources and fixes the broken URIs and
links. The tool can be found in `/tools` directory from the MicroSys package.

Copy "migrate_repo.py" to the `workspace` directory and start the tool to download repo and fix links.
```
# ./migrate_repo.py -u https://source.codeaurora.org/external/qoriq/qoriq-components/yocto-sdk -b scarthgap
```
After successfull execution of the above command you should see the following message:
```
========================================
The URLs have been fixed in all recipes!
You can now continue with your build tasks.
```

4. Unpack MicroSys' layer in the directory `./sources`

This is for Layerscape LSDKs:

`./sources/meta-microsys-layerscape`

*Note 1*: you should then have a directory with the layer name in `./sources.`

*Note 2*: the name of the top directory in the TAR-ball or ZIP-file could contain a revision in its name. For Layerscape
LSDKs rename it to `meta-microsys-layerscape`.

5. Convert URLs in MicroSys' layer

For Layerscape LSDKs call:
```
# ./migrate_repo.py --fix-path ./sources/meta-microsys-layerscape
```

6. Patch the script setup-env:
```
# chmod u+w setup-env
# patch < ./sources/meta-microsys-layerscape/setup-env_lsdk-scarthgap.patch
```

7. Source the script setup-env:
```
$ export DISTRO=microsys-networking
$ . setup-env -m mpxls1088acrx09-adx03
```
You are now ready to build the machine `mpxls1088acrx09-adx03`.

8. Start the build for the image 'microsys-image-networking':
```
$ bitbake microsys-image-networking
```

## Apply the SD-card Image

You can put the image onto your SD-card with:
```
# dd if=microsys-image-networking-mpxls1088acrx09-adx03-<DATE>.rootfs.sdcard of=/dev/sd_x_ bs=512 && sync
```
with /dev/sd_x_ as device of your SD-card. The SD-card is a bootable media.

# Interface Layout

## MPXLS1088A/CRX06

### 2xTSN

                                 QSGMII2            QSGMII1
                             +-------+-------+  +-------+-------+
                             |DPMAC8 |DPMAC10|  |   X   |   X   |
                             | 1Gb   | 1Gb   |  |       |       |
       +-------+ +-------+   +-------+-------+  +-------+-------+
       |DPMAC1 | |DPMAC2 |   |DPMAC7 |DPMAC9 |  |DPMAC3 |   X   |
       | 10Gb  | | 10Gb  |   | 1Gb   | 1Gb   |  | 1Gb   |       |
    ---+-------+-+-------+---+-------+-------+--+-------+-------+- ...

           +-------+ +-------+ +-------+ +-------+
    TSN2:  |SW2P3  | |SW2P2  | |SW2P1  | |SW2P0  |
           |PHY@4  | |PHY@5  | |PHY@6  | |PHY@7  |
           +-------+ +-------+ +-------+ +-------+
    TSN1:  |SW1P3  | |SW1P2  | |SW1P1  | |SW1P0  |
           |PHY@0  | |PHY@1  | |PHY@2  | |PHY@3  |
    ... ---+-------+-+-------+-+-------+-+-------+--

# Notes for Developers

## Create Your Own Layer <span id="create-layer"/>

Before you start modifying recipes it is the best when you create your own layer which
is supposed to contain your changes.

1. If not already done go to the build directory of the machine and call:

```
$ . SOURCE_THIS
```

This configures and starts bitbake.

2. Go to the sources/ directory and create your layer there:

```
$ bitbake-layers create-layer --priority 20 meta-mylayer
```
*Note 1:* because the priority of meta-microsys-auto is 13, it is recommended to choose a higher number as priority for
your own layer (but less than 99).

*Note 2:* it is good practice to prefix the layer name with "meta-".

*Note 3:* this is an optional step. You can remove the directory recipes-example in the directory meta-mylayer/.

3. Go to the build directory of the machine and add your new layer with:
```
$ bitbake-layers add-layer ../sources/meta-mylayer
```
Now you are ready for modifying sources.

## Modifying U-Boot or Linux Kernel

You can modify the sources of U-Boot using the Yocto tool devtool. This task assumes that you have created your own
layer as described in the section [Create Your Own Layer](#create-layer).

*Note:* This works for other recipes, too. For example, if you plan to modify the Linux kernel use  _linux-qoriq_  as
recipe name.

1. If not already done go to the build directory of the machine and call:
```
$ . SOURCE_THIS
```
This configures and starts bitbake.

2. Call devtool with the recipe for U-Boot as argument:
```
$ devtool modify u-boot-qoriq
```
This creates a layer called "workspace" which contains the U-Boot sources as a GIT-repository. The sources can be found
in the directory `<workspace>/sources/u-boot-qoriq`

*Note:* if you have done this step before, for example from a previous modification, then you have to call:

```
$ devtool modify --no-extract u-boot-qoriq
```

with the additional option '--no-extract'. In this case devtool expects that the source tree already exists.

3. Modify the sources with your favourite editor.

4. Build your U-Boot with:
```
$ devtool build u-boot-qoriq
```
You can find the results in workspace/sources/u-boot-qoriq/oe-workdir/image/boot. The resulting U-Boot images are:

- u-boot.bin
- u-boot.bin-tfa

(The results for the Linux kernel can be found in workspace/sources/linux-qoriq/oe-workdir/image/boot)

If you now want to test your new U-Boot you can create a new boot image with:
```
$ devtool build-image microsys-image-networking
```
You can find the output files in tmp/deploy/images/mpxls1088crx05.

5. Once you're done with your changes finish your work

- go to workspace/sources/u-boot-qoriq and commit your changes using 'git'
- Update the recipe with:
```
$ devtool finish u-boot-qoriq meta-mylayer
```
This copies and saves your changes into meta-mylayer.

If you plan to make more modifications to U-Boot it's better not to delete the source tree from the `workspace`
directory.

*Note:* If you think that you are done with all of your changes then you can remove the recipe from the workspace layer
with:
```
$ devtool reset u-boot-qoriq
```
This will  **erase all**  of your changes from workspace.

6. Now you can rebuild your image including your changes with:
```
$ bitbake microsys-image-networking
```
*Note:* if you want to modify the Linux kernel configuration you can call:
```
$ bitbake -c menuconfig linux-qoriq
```

## Generating the Cross-Toolchain

For cross-development on the host you can generate and install a cross-toolchain using Yocto build environment.
Currently Poky has a problem which can be fixed with a patch provided in tools directory from MicroSys package. Change
directory to `<workspace>/sources/poky` and copy the file `poky-skip-broken.diff` to this directry. Then apply the patch
with
```
$ patch -p1 < poky-skip-broken.diff
```
You should see a result
```
patching file meta/lib/oe/package_manager/rpm/__init__.py
Hunk #1 succeeded at 304 (offset -7 lines).
```
Change to workspace directory and call
```
$ bitbake -c populate_sdk microsys-image-networking
```
This generates a self-extractor (shar) in the directory `build_<machine>/tmp/deploy/sdk` called
`microsys-networking-glibc-x86_64-microsys-image-networking-aarch64-<machine>-toolchain-<version>.sh` which can be
installed on your build host.

Further steps would include seting up development environment on local build host, installing remote debugger on target
and start developing application code.

## CRX06 and TSN

### MPXLS1088A

In order to bring-up a network connection of a TSN-switch you need to bring-up the uplink between CPU and switch first.

For TSN-switch 1 this is dpmac4 and for TSN-switch 2 this is dpmac5. For example:
```
$ ifconfig dpmac4 up
$ ifconfig sw1p0 192.168.178.10
```
Brings up port 0 on switch 1 with the IP-address 192.168.178.10.

## Artificial Intelligence

### M.2 Hailo module

Some requirements are necessary in order to be able to use it with Layerscape processors.

- Download the hailo layer from https://github.com/hailo-ai/meta-hailo/tree/master and place it inside the /sources folder where all other layers reside in.

Within the meta-hailo folder open the terminal and type following:

_**NOTICE: Folders within meta-hailo need to be moved into /sources folder!**_

 - **git clone https://github.com/hailo-ai/meta-hailo.git**
 - **git status** ("See if you are on the correct branch")
 - If not on the correct branch you need checkout with the command **git checkout kirkstone**
 - To check if the kirkstone branch has been checked out use **git status** once again.
 - After that there will be 4 different folders withtin meta-hailo folder: **meta-hailo-accelerator**; **meta-hailo-libhailort**; **meta-hailo-tappas**; **meta-hailo-vpu** copy those folders and paste them into the /sources folder where all other layers reside in.

NOTICE: In bblayers.conf these layers need to be also included, i.e:

  ../sources/meta-hailo-accelerator

  ../sources/meta-hailo-libhailort

  ../sources/meta-hailo-tappas

Workaround:
 - Inside the **tappas-apps_*.bb** recipe comment out the following line **d.appendVar('DEPENDS', " libgstmedialib xtensor")**

After all these steps have been done one could use the following command to build an image which contains hailo in it:

**devtool build-image microsys-image-hailo** or **bitbake microsys-image-hailo**


