# Copyright (C) 2020-2024 MicroSys Electronics GmbH
# Authors: Kay Potthoff <kay.potthoff@microsys.de>, Florian Aigner <florian.aigner@microsys.de>

inherit microsys

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:"
PATCHTOOL = "git"
PATCH_COMMIT_FUNCTIONS = "1"

S32_VERSION:s32g2 = "s32g2"
S32_VERSION:s32g3 = "s32g3"
NXP_FIRMWARE_LOCAL_DIR = "${S}/../NXPFWGITREPO/pfe/${S32_VERSION}/"

LIC_FILES_CHKSUM += "${@bb.utils.contains('DISTRO_FEATURES', \
    'pfe-fw-load', \
    "file://${NXP_FIRMWARE_LOCAL_DIR}/PFE-License.txt;md5=3efaacbb2298460a2345c5950a9ebb6a", \
    '', d)}"

COMPATIBLE_MACHINE:append = "|mpxs32g"

do_compile[depends] += "virtual/kernel:do_deploy"

#URL:append = ";branch=master"
#Version 1.7.0
SRCREV = "fa89bd271719146c6f6103a348ea727568504c25"

FWDIR = "${D}${nonarch_base_libdir}/firmware"
SRC_URI += '${@bb.utils.contains("DISTRO_FEATURES", "pfe-fw-load", d.getVar('URI_NXPFWGITREPO'), "", d)}'

SRC_URI += "file://0001-sw-Fix-crashes-on-shutdown-PFE-using-MDIO.patch;name=patch0001"
SRC_URI += "file://0002-sw-linux-pfeng-mdio.c-fixed-return-codes.patch;name=patch0002"
SRC_URI += "file://0003-sw-linux-pfeng-pfeng-drv.c-fixes-sporadic-kernel-cra.patch;name=patch0003"
SRC_URI += "file://0004-hw-s32g-pfe_tmu_csr.c-no-TMU-for-S32G2.patch;name=patch0004"

SRC_URI[patch0001.md5sum] = "efff7f347022ef47fbb7827953497d8c"
SRC_URI[patch0002.md5sum] = "a0aa9596bc3c11b514f0e34d6947204d"
SRC_URI[patch0003.md5sum] = "78c427bbd4bb05feb8f530cd8e35fdcc"
SRC_URI[patch0004.md5sum] = "c0020aa57f2bdd1a6c4c70d115a02493"

python do_patch:prepend() {
    if d.getVar('PATCHTOOL') == 'git':
        srcsubdir = d.getVar('S')
        bb.process.run('git config am.threeWay true', cwd=srcsubdir)
        bb.process.run('git config am.keepcr true', cwd=srcsubdir)
        bb.process.run('git config apply.whitespace fix', cwd=srcsubdir)
        bb.process.run('git config apply.ignoreWhitespace no', cwd=srcsubdir)
}

do_patch:append() {
    import shutil

    if "pfe-fw-load" in d.getVar('DISTRO_FEATURES'):
        class_name = os.path.join(d.getVar("S"), d.getVar("FW_INSTALL_CLASS_NAME"))
        util_name = os.path.join(d.getVar("S"), d.getVar("FW_INSTALL_UTIL_NAME"))

        shutil.copy2(os.path.join(d.getVar("NXP_FIRMWARE_LOCAL_DIR"),
                                d.getVar("PFE_FW_CLASS_BIN")),
                    class_name)

        shutil.copy2(os.path.join(d.getVar("NXP_FIRMWARE_LOCAL_DIR"),
                                d.getVar("PFE_FW_UTIL_BIN")),
                    util_name)

        os.chmod(class_name, 0o0644)
        os.chmod(util_name, 0o0644)
}

module_do_install() {
    mkdir -p ${INSTALL_DIR}
    install -D "${MDIR}/pfeng.ko" "${INSTALL_DIR}/pfeng.ko"
    if ${@bb.utils.contains('DISTRO_FEATURES', 'pfe-fw-load', 'true', 'false', d)}; then
        mkdir -p "${FW_INSTALL_DIR}"
        install -D -m 0644 "${NXP_FIRMWARE_LOCAL_DIR}/${PFE_FW_CLASS_BIN}" "${FW_INSTALL_DIR}/${FW_INSTALL_CLASS_NAME}"
        install -D -m 0644 "${NXP_FIRMWARE_LOCAL_DIR}/${PFE_FW_UTIL_BIN}" "${FW_INSTALL_DIR}/${FW_INSTALL_UTIL_NAME}"
        install -D -m 0644 "${NXP_FIRMWARE_LOCAL_DIR}/${PFE_FW_CLASS_BIN}" "${D}/${FW_INSTALL_CLASS_NAME}"
        install -D -m 0644 "${NXP_FIRMWARE_LOCAL_DIR}/${PFE_FW_UTIL_BIN}" "${D}/${FW_INSTALL_UTIL_NAME}"
    fi
}

python do_fetch:prepend() {
    # Due to lack of yocto kirkstone features, its hard to do this check in a better way that doesn't flag false negatives
    if "pfe-fw-load" in d.getVar('DISTRO_FEATURES') and "microsys.local" in d.getVar('URI_NXPFWGITREPO'):
         bb.warn("You will try to fetch NXP Firmware from internal microsys servers.")
         bb.warn("In case you see a fetch error afterwards, please check the \"software enablement guide\" as part of release notes.")
}

FILES:${PN} += "/${FW_INSTALL_CLASS_NAME} /${FW_INSTALL_UTIL_NAME}"

# This is a workaround for the build error
# "basehash value changed"
do_populate_sysroot[vardepsexclude] += "PROVIDES"
do_populate_setscene[vardepsexclude] += "PROVIDES"
do_package[vardepsexclude] += "PROVIDES RPROVIDES_${PN}"
