# Copyright (C) 2021-2024 MicroSys Electronics GmbH
# Authors: Kay Potthoff <kay.potthoff@microsys.de>, Florian Aigner <florian.aigner@microsys.de>

inherit microsys

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:"

HSE_MACHINE:s32g2 = "S32G2XX"
HSE_MACHINE:s32g3 = "S32G3XX"

HSE_VERSION:s32g2 = "0_1_0_14"
HSE_VERSION:s32g3 = "0_2_22_0"

S32_VERSION:s32g2 = "s32g2"
S32_VERSION:s32g3 = "s32g3"

# Define a primary and backup filename.
# Both will be flashed.
# Using different versions (not revs) might have consequences for apps using the API => avoid this
HSE_SOC_REV:s32g2 = "rev${SOC_REV}_s32g2xx_hse_fw_0.1.0_1.0.14"
# Firmware shall use the Rev2.0 version for older SoCs
HSE_BACKUP_SOC_REV:s32g2 = "rev2.0_s32g2xx_hse_fw_0.1.0_1.0.14"

HSE_SOC_REV:s32g3 = "rev${SOC_REV}_s32g3xx_hse_fw_0.20.0_2.22.0"
HSE_BACKUP_SOC_REV:s32g3 = "rev${SOC_REV}_s32g3xx_hse_fw_0.20.0_2.22.0"

HSE_FW_DEPLOY_DIR ?= "${@microsys_get_hse_fw_dir(d)}"
HSE_FW_IMG ?= "${@microsys_get_hse_fw_image(d)}"
HSE_FW_BACKUP_IMG ?= "${@microsys_get_hse_fw_image(d, backup=True)}"

HSE_DIR = "${WORKDIR}/NXPFWGITREPO/hse/${S32_VERSION}/HSE_FW_${HSE_MACHINE}_${HSE_VERSION}"

HSE_LIC = "${HSE_DIR}/license.rtf"

HSE_LIC_MD5:s32g2 = "b42f27118a6267cf18ff525c60dfd9af"
HSE_LIC_MD5:s32g3 = "a1bda359fc5cdcfca04f84834841a5ca"
LIC_FILES_CHKSUM = "file://${HSE_LIC};md5=${HSE_LIC_MD5}"

SRC_URI := '${@bb.utils.contains("DISTRO_FEATURES", "hse", d.getVar('URI_NXPFWGITREPO'), "", d)}'

python do_fetch:prepend() {
    # Due to lack of yocto kirkstone features, its hard to do this check in a better way that doesn't flag false negatives
    if "hse" in d.getVar('DISTRO_FEATURES') and "microsys.local" in d.getVar('URI_NXPFWGITREPO'):
         bb.warn("You will try to fetch NXP Firmware from internal microsys servers.")
         bb.warn("In case you see a fetch error afterwards, please check the \"software enablement guide\" as part of release notes.")
}

do_install() {
	install -d ${HSE_FW_DIR}
	install -d ${HSE_INT_DIR}

	install -m 0644 ${HSE_DIR}/hse/bin/${HSE_SOC_REV}*.bin.pink ${HSE_FW_DIR}/s32cc_hse_fw.bin
	install -m 0644 ${HSE_DIR}/hse/bin/${HSE_BACKUP_SOC_REV}*.bin.pink ${HSE_FW_DIR}/s32cc_hse_backup_fw.bin
	cp -r ${HSE_DIR}/interface/ ${HSE_INT_DIR}
}

