Copyright (C) 2020-2022 MicroSys Electronics GmbH

Release Notes for SJA1110 Firmware on CRX-S32G
This Part contains the setup for CRX-S32g with the desired configuration
The corresponding generic driver sources are in the GIT repository firmware/S32SDK-SJA1110.
========================================================================

Repository
===========
firmware/SJA1110

Supported Platforms
===================

CRX-S32G Revision 2 + 3

GIT branches
============

	- master branch             : SJA1110 Firmware FLASH Image for SJA<-->S32G 1Gbit connection. For 2.5GBit, switch for Phy 3 from 1 to 2.5GBit

Firmware Files
==============

Depending on the used GIT branch (see above), the base file is Debug_FLASH/flash_image.bin which results in:
	- sja1110_uc_2g5.bin	: SJA1110 Firmware FLASH Image for SJA<-->S32G 2.5Gbit connection
	- sja1110_uc_m2.bin		: SJA1110 Firmware FLASH Image for SJA<-->S32G 1.0Gbit connection (m2 means M.2 slot on S32G)

Limitations
===========

Change History
==============

The Change History will be the same for firmware/S32SDK_SJA1110 and firmware/SJ1110 as both belong together.
See src/history.h

1.2.4: 2024-12-18
---------------

- Improved tables for HTML pages, no functional changes

1.2.3: 2024-11-24
---------------

- Updated S32DS from 3.4 to 3.5
- Updated RTM 1.0.0 to 1.0.2
- Officially added support for CRX Rev 3

1.0.9: 2022-10-21
---------------

- 88Q2112 has the INT# output connected to all other Phys, going to the CPU, not to the SJA. Here we have to make sure
  that the INT# is not getting blocked for the other Phys by not setting the Pin to Open-Drain or Tri-State.
- same for 88E1512 LED2/INT# output. This is by default Push/Pull and therefore holding the INT# high for all other Phys.

1.0.8: 2022-08-04
---------------

- Fixed the 88E1512 Phy startup. On the R3 Board, the Phy is setting the Register 0_16 on
  power-up to some weird Energy Detect mode. Most time with the SW wake-up Bit set, so that
  it will not get a link until a hard-reset or a Software wake-up. Solution is to set the
  Register 0_16 with 0x3070 with Energy Detect Off (9:7 = 000). At the same time, the Register
  0_4 (Autoneg Advertisement for 10/100Mbit) is 0x0001 instead of 0x01e1. This is set as well.
- Add LWIP_HTTPD_CUSTOM_FILES to allow to add our own html page for showing status.
  The implementation of the html is done in main.c of the customer part.

1.0.7: 2022-04-08
---------------

- Fixed an issue that the ifdef CRX_FIX_FOR_LATE_STARTING_OSZILLATOR included the enable and start of the Autonegotiation and therefore missing if it is not set.
- 100BaseT1 Removed the Extended Configuration for Wake-Sleep modes.

1.0.6: 2021-11-18
---------------

- Set the RGMII TX/RX delay for 88Q2112 to default true/true or in the configuration the "Manual propagation delay for correction" is set to manual
-- MII to MDI min >= 1 for TX delay == true (0 == false)
-- MDI to MII min >= 1 for RX delay == true (0 == false)
-  88Q2112 Master/Slave from configuration.
-  88Q2112 Do the chip initialization every time, even if the link is already established.

1.0.5: 2021-10-25
---------------

- Removed the fix for the PHY due to late start of the oszillator. The previous 1.0.4 is marked as "internal use only" in the branch "1_0_4_fix_for_oszillator_starting_late"

1.0.4: 2021-09-07
---------------

- Modified startup of 88E1512 Phy for possible fails in Power Up of the PHY. The Register 26 is power-up with 0x7040, but it must be 0x0040.
- Added PHY register read and save into an array for debugging. phydata and initial_phydata are arrays of words with Page<<8 + Register , Register Value

1.0.3: 2021-08-06
---------------

- If one PHY failed to initialize, the PHY init loop was terminated. Now the other will continue to be initialze and the yellow LED on the 100BaseT Connector will be switched on to indicate an failure.
- In the Configuration, the 1000Base-T1 PHY was not clause45 enabled. This caused the PHY to terminate the PHY init loop.

1.0.2: 2021-07-09
---------------

- Started ReleaseNotes-microsys.md
- Modified the PHY setup for M88E1512 to disable the 125MHz Clock generation

1.0.1: 2021-03-24
---------------

- Added 1.0 and 2.5GBit uplink speed settings

