# Copyright (C) 2024 MicroSys Electronics GmbH
# Authors: Florian Aigner <florian.aigner@microsys.de>
#
SUMMARY = "Sample M7 Bootloader"
LICENSE = "BSD-3-Clause"
LIC_FILES_CHKSUM = "file://LICENSE.BSD;md5=0f00d99239d922ffd13cabef83b33444"
SRCREV ?= "49a1a2b4754c60415f4a181b1c8a91cebe23efd6"

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:"
SRC_URI:append = " file://m7-boot.patch"

do_compile() {
	for suffix in ${BOOT_TYPE}
	do
		ivt_file="${IVT_FILE_BASE}-${suffix}"

		BDIR="${BUILD}-${suffix}"

		oe_runmake CROSS_COMPILE="arm-none-eabi-" \
			BUILD="${BDIR}" clean

		mkdir -p "${BDIR}"
		cp -vf "${DEPLOY_DIR_IMAGE}/${ivt_file}" "${BDIR}/"

		oe_runmake CROSS_COMPILE="arm-none-eabi-" \
			BUILD="${BDIR}" DISABLE_A53_LOCKSTEP=y \
			A53_BOOTLOADER="${BDIR}/${ivt_file}"
	done
}