# Copyright (C) 2019-2023 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>

do_image_sdcard[depends] += " \
    ${@d.getVar('ATF_IMAGE_FILE', True) and d.getVar('ATF_IMAGE', True) + ':do_deploy' or ''} \
"

do_image_sdcard[depends] += " \
	${@d.getVar('IMAGE_BOOTLOADER', True) and d.getVar('IMAGE_BOOTLOADER_RECIPE', True) + ':do_deploy' or ''} \
"

create_sparse_file() {

    rootfs=$1
    sdcard=$2

    if [ -z "${rootfs}" ]; then
        bberror "${rootfs} is undefined."
        exit 1
    fi

    bbdebug 1 "rootfs=${rootfs}"

    ROOTFS_SIZE=$(stat -L --printf="%s" ${rootfs})

    bbdebug 1 "ROOTFS_SIZE=${ROOTFS_SIZE}"

    SDCARD_SIZE=$(expr ${ROOTFS_SIZE} + 256 \* 1024)

    PART_START=$(expr 64 \* 2048)

    bbdebug 1 "sdcard=${sdcard}"
    bbdebug 1 "SDCARD_SIZE=${SDCARD_SIZE}"
    bbdebug 1 "PART_START=${PART_START}s"

    # Initialize a sparse file
    dd if=/dev/zero of=${sdcard} bs=1k count=0 seek=${SDCARD_SIZE}

    echo $PART_START
}

partition_sparse_file() {

    sdcard=$1
    part_start=$2

    parted --script ${sdcard} mklabel msdos
    parted ${sdcard} mkpart primary ext4 ${part_start}s 100%
    bbdebug 1 $(parted ${sdcard} print)
}

IMAGE_TYPEDEP_tfa-sdcard:append = " ${@d.getVar('SDCARD_ROOTFS', 1).split('.')[-1]}"

IMAGE_CMD:sdcard:mpxs32g () {

    PART_START=$(create_sparse_file ${SDCARD_ROOTFS} ${SDCARD})

    partition_sparse_file ${SDCARD} ${PART_START}

    dd if=${DEPLOY_DIR_IMAGE}/${UBOOT_NAME_SDCARD} of=${SDCARD} conv=notrunc,fsync bs=256 seek=0 count=1
    dd if=${DEPLOY_DIR_IMAGE}/${UBOOT_NAME_SDCARD} of=${SDCARD} conv=notrunc,fsync bs=512 seek=1 skip=1
    dd if=${SDCARD_ROOTFS} of=${SDCARD} conv=notrunc,fsync seek=${PART_START} bs=512

    if [ "${SDCARD_PARTITION_LAYOUT}" = "GPT" ]; then
		# Appends space for GPT backup
		dd if=/dev/zero bs=1M count=1 >> ${sdcard}
		# Limt to 24 entries (max space before the next image at 0x1000) and switch to GPT
		sgdisk --mbrtogpt --resize-table=24 "${sdcard}"
	fi
}

IMAGE_TYPEDEP:sdcard:append:mpxs32g = " ${@d.getVar('SDCARD_ROOTFS', 1).split('.')[-1]}"

IMAGE_CMD:qspi () {

    QSPIIMG="${IMGDEPLOYDIR}/${IMAGE_NAME}${IMAGE_NAME_SUFFIX}.qspi"

    IMG_SIZE=$(expr 3 \* 1024) # == 3MB

    dd if=/dev/zero of=${QSPIIMG} bs=1k count=0 seek=${IMG_SIZE}
    dd if=${DEPLOY_DIR_IMAGE}/${FLASHIMAGE_UBOOT_FILE} of=${QSPIIMG} conv=notrunc,fsync bs=512 seek=0
}

IMAGE_CMD:ramdisk () {
    mkimage -A arm -T ramdisk -d ${IMGDEPLOYDIR}/${IMAGE_NAME}${IMAGE_NAME_SUFFIX}.cpio.gz ${IMGDEPLOYDIR}/${IMAGE_NAME}${IMAGE_NAME_SUFFIX}.ramdisk
}
