# Copyright (C) 2022-2023 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>

SUMMARY = "MPXS32G274A Debug Support"
DESCRIPTION = "Installs debugger scripts"
LICENSE = "CLOSED"

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:"

SRC_URI = "file://atf-mpxs32g274a_a53_0.cmm"
SRC_URI += "file://u-boot-mpxs32g274a_a53_0.cmm"
SRC_URI += "file://linux-mpxs32g274a_a53_0.cmm"

FILES:${PN} += "/usr/share/debug"

do_configure[noexec] = "1"
do_compile[noexec] = "1"

DEBUG_SCRIPTS = " \
	atf-mpxs32g274a_a53_0.cmm \
	u-boot-mpxs32g274a_a53_0.cmm \
	linux-mpxs32g274a_a53_0.cmm \
"

do_patch() {
    for scr in ${DEBUG_SCRIPTS}; do
        install -m 0644 ${WORKDIR}/${scr} ${S}/${scr}
    done
}

do_install() {
    install -m 0755 -d ${D}/usr/share/debug/lauterbach
    for scr in ${DEBUG_SCRIPTS}; do
        install -m 0644 -o root -g root ${S}/${scr} ${D}/usr/share/debug/lauterbach/${scr}
    done
}

BBCLASSEXTEND = "nativesdk"
