# Copyright (C) 2020-2023 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>

inherit deploy

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:"

SJA1110_FW_REV = "1.2.4"

SRC_URI += "file://sja1110_uc_2g5.${SJA1110_FW_REV}.bin"
SRC_URI += "file://sja1110_uc_m2.${SJA1110_FW_REV}.bin"
SRC_URI += "file://ReleaseNotes-microsys.md"

COMPATIBLE_MACHINE:append = "|s32g274ar2sbc3|s32g274ar2sbc2|s32g274ar5sbc3"
COMPATIBLE_MACHINE:append = "|s32g399ar5sbc3|s32g399ar5sbc2"

do_compile[depends] += "virtual/kernel:do_deploy"

module_do_install:append() {

    install -d ${D}/lib/firmware

    if [ -f "${WORKDIR}/sja1110_uc_m2.${SJA1110_FW_REV}.bin" ]; then
        install -m 0644 ${WORKDIR}/sja1110_uc_m2.${SJA1110_FW_REV}.bin ${D}/lib/firmware/sja1110_uc_m2.bin
        bbplain "SJA1110.M2 firmware: ${WORKDIR}/sja1110_uc_m2.${SJA1110_FW_REV}.bin"
    fi

    if [ -f "${WORKDIR}/sja1110_uc_2g5.${SJA1110_FW_REV}.bin" ]; then
        install -m 0644 ${WORKDIR}/sja1110_uc_2g5.${SJA1110_FW_REV}.bin ${D}/lib/firmware/sja1110_uc_2g5.bin
        bbplain "SJA1110.2G5 firmware: ${WORKDIR}/sja1110_uc_2g5.${SJA1110_FW_REV}.bin"
    fi

    cp -f ${WORKDIR}/ReleaseNotes-microsys.md ${D}/lib/firmware/ReleaseNotes-microsys-sja1110_uc-${SJA1110_FW_REV}.md
}

do_deploy() {
    if [ -f "${WORKDIR}/sja1110_uc_m2.${SJA1110_FW_REV}.bin" ]; then
        cp ${WORKDIR}/sja1110_uc_m2.${SJA1110_FW_REV}.bin ${DEPLOYDIR}/sja1110_uc_m2.bin
        bbplain "Deploy SJA1110.M2 firmware: ${WORKDIR}/sja1110_uc_m2.${SJA1110_FW_REV}.bin"
    fi

    if [ -f "${WORKDIR}/sja1110_uc_2g5.${SJA1110_FW_REV}.bin" ]; then
        cp ${WORKDIR}/sja1110_uc_2g5.${SJA1110_FW_REV}.bin ${DEPLOYDIR}/sja1110_uc_2g5.bin
        bbplain "Deploy SJA1110.2G5 firmware: ${WORKDIR}/sja1110_uc_2g5.${SJA1110_FW_REV}.bin"
    fi
    cp ${WORKDIR}/ReleaseNotes-microsys.md ${DEPLOYDIR}/ReleaseNotes-microsys-sja1110_uc-${SJA1110_FW_REV}.md
}

addtask do_deploy after do_unpack