# Copyright (C) 2020-2024 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>

require recipes-fsl/images/fsl-image-auto.bb
PREFERRED_VERSION_linux-s32 = "6.%"

S32_VERSION:s32g2 = "s32g2"
S32_VERSION:s32g3 = "s32g3"

IMAGE_INSTALL:append:mpxs32g = "${@bb.utils.contains('DISTRO_FEATURES', 'pfe', ' pfe ', '', d)}"
IMAGE_INSTALL:append:mpxs32g = "${@bb.utils.contains('DISTRO_FEATURES', 'sja1110', ' sja1110 ', '', d)}"
IMAGE_INSTALL:append = " vlan "

IMAGE_INSTALL:append = " arm-trusted-firmware "

IMAGE_INSTALL:append = "${@bb.utils.contains('DISTRO_FEATURES', 'wifi', ' hostapd kea ', '', d)}"

IMAGE_INSTALL:append = "${@bb.utils.contains('DISTRO_FEATURES', 'docker', ' docker-ce ', '', d)}"

MACHINE_ESSENTIAL_EXTRA_RRECOMMENDS:mpxs32g += "${@bb.utils.contains('DISTRO_FEATURES', \
    'wifi', \
    ' linux-firmware-rtw88 \
      linux-firmware-ath10k \
      kernel-module-rtw88-8822ce \
      kernel-module-rtw88-8822c \
      kernel-module-rtw88-core \
      kernel-module-rtw88-pci \
      kernel-module-ath \
      kernel-module-ath10k \
      kernel-module-ath10k-core ' \
    '', d)}"

MACHINE_ESSENTIAL_EXTRA_RRECOMMENDS:mpxs32g += "kernel-module-pfe"
MACHINE_ESSENTIAL_EXTRA_RRECOMMENDS:mpxs32g += "${@bb.utils.contains('DISTRO_FEATURES', \
    'sja1110', 'kernel-module-sja1110', '', d)}"

MICROSYS_IMAGE_EXTRA_INSTALL += " \
    parted e2fsprogs-resize2fs bashprofile \
    linux-s32-tools libgpiod libgpiod-tools libgpiod-python libgpiodcxx \
    stressapptest \
"

MICROSYS_IMAGE_EXTRA_INSTALL += "${@bb.utils.contains('DISTRO_FEATURES', \
                                   'systemd', 'systemd pm-utils', '', d)}"

IMAGE_INSTALL += "${MICROSYS_IMAGE_EXTRA_INSTALL}"

IMAGE_INSTALL:remove = "kernel-devicetree"
IMAGE_INSTALL:remove = "gnuplot"
IMAGE_INSTALL:remove = "kernel-pcitest"
IMAGE_INSTALL:remove = "aquantia-firmware-utility"
IMAGE_INSTALL:remove = "irqbalance"

# Hailo support
#IMAGE_INSTALL:append = "${@bb.utils.contains('DISTRO_FEATURES', \
#    'hailo', \
#    ' packagegroup-hailo-hailort packagegroup-hailo-tappas ', \
#    '', d)}"

MACHINE_ESSENTIAL_EXTRA_RRECOMMENDS:mpxs32g += "${@bb.utils.contains('DISTRO_FEATURES', \
    'hailo', 'kernel-module-hailo-pci', '', d)}"

IMAGE_INSTALL:append = "${@bb.utils.contains('DISTRO_FEATURES', \
    'hailo', \
    ' libhailort hailortcli pyhailort libgsthailo hailo-pci hailo-firmware ', \
    '', d)}"

IMAGE_INSTALL:append = "${@bb.utils.contains('DISTRO_FEATURES', \
    'hailo', \
    ' libgsthailotools hailo-post-processes tappas-tracers ', \
    '', d)}"

SDCARD_ROOTFS = "${IMGDEPLOYDIR}/${IMAGE_BASENAME}-${MACHINE}.ext4"
# Drops first partition, disable for now
#SDCARD_PARTITION_LAYOUT = "GPT"

DEPENDS += "parted-native u-boot gptfdisk-native"
DEPENDS += "arm-trusted-firmware"

do_cleaned_firmware_image[depends] += "e2fsprogs-native:do_populate_sysroot"
do_image_ext4[depends] += "e2fsprogs-native:do_populate_sysroot"
do_image_ext3[depends] += "e2fsprogs-native:do_populate_sysroot"
do_image_sdcard[deptask] += "do_rootfs"
do_image_sdcard[deptask] += "do_image_ext4"
do_image_sdcard[deptask] += "do_image_qspi"
do_rootfs_kernelitb[deptask] += "virtual/kernel:do_deploy"
do_image_sdcard[depends] += "arm-trusted-firmware:do_deploy"
do_image_qspi[depends] += "arm-trusted-firmware:do_deploy"

IMAGE_FSTYPES:remove = "cpio.gz.u-boot"
IMAGE_FSTYPES:remove = "ext3"
IMAGE_FSTYPES += "ext4"
IMAGE_FSTYPES:append:mpxs32g = " qspi"

do_rootfs_kernelitb() {
    :
    #cp -a ${DEPLOY_DIR_IMAGE}/fitImage*.itb ${IMAGE_ROOTFS}/boot
    #cp -a ${DEPLOY_DIR_IMAGE}/Image.gz ${IMAGE_ROOTFS}/boot
}
addtask rootfs_kernelitb after do_rootfs before do_image

do_rootfs_firmware() {
}

do_rootfs_firmware:mpxs32g() {
    :
    # PFE firmware:
    # cp -a ${DEPLOY_DIR_IMAGE}/${SDCARDIMAGE_BOOT_EXTRA2_FILE} ${IMAGE_ROOTFS}

    # QSPI U-Boot:
    #mkdir -p ${IMAGE_ROOTFS}/boot
    #cp ${DEPLOY_DIR_IMAGE}/${FLASHIMAGE_UBOOT_FILE} ${IMAGE_ROOTFS}/boot
}

do_cleaned_firmware_image() {
    PART_START=131072

    SDCARD_EXTERNAL=`ls ${DEPLOY_DIR_IMAGE}/microsys-*.rootfs.sdcard | sed 's#rootfs.sdcard#nonxpfirmware.sdcard#'`
    SDCARD_ROOTFS_EXTERNAL="${DEPLOY_DIR_IMAGE}/TMP_DISK.ext4"

    cp ${DEPLOY_DIR_IMAGE}/microsys-*.rootfs.sdcard ${SDCARD_EXTERNAL}
    cp ${DEPLOY_DIR_IMAGE}/microsys-*.rootfs.ext4 ${SDCARD_ROOTFS_EXTERNAL}

    # Get locations where blocks are delete the metadata
    echo "open -w ${SDCARD_ROOTFS_EXTERNAL}" > instructions
    echo "blocks /s32g_pfe_util.fw" >> instructions
    echo "blocks /s32g_pfe_class.fw" >> instructions
    echo "blocks /lib/firmware/s32g_pfe_util.fw" >> instructions
    echo "blocks /lib/firmware/s32g_pfe_class.fw" >> instructions
    echo "blocks /lib/firmware/dte.bin" >> instructions
    echo "blocks /lib/firmware/frpe.bin" >> instructions
    echo "blocks /lib/firmware/ppe_rx.bin" >> instructions
    echo "blocks /lib/firmware/ppe_tx.bin" >> instructions
    echo "rm /s32g_pfe_util.fw" >> instructions
    echo "rm /s32g_pfe_class.fw" >> instructions
    echo "rm /lib/firmware/s32g_pfe_util.fw" >> instructions
    echo "rm /lib/firmware/s32g_pfe_class.fw" >> instructions
    echo "rm /lib/firmware/dte.bin" >> instructions
    echo "rm /lib/firmware/frpe.bin" >> instructions
    echo "rm /lib/firmware/ppe_rx.bin" >> instructions
    echo "rm /lib/firmware/ppe_tx.bin" >> instructions
    echo "close" >> instructions

    # Extract block numbers from output
    NXP_FW_BLOCKS=`debugfs -f instructions | grep -Eo '[0-9]{1,10} '`
    echo "Will run on those blocks:"
    echo "${NXP_FW_BLOCKS}"

    # ZAP all those blocks, equals to overwrite data
    echo "open -w ${SDCARD_ROOTFS_EXTERNAL}" > instructions
    echo "$NXP_FW_BLOCKS" | while read -r a; do echo "zap_block $a" >> instructions; done
    echo "close" >> instructions

    debugfs -f instructions

    # Reconstruct full SD image
    dd if=${SDCARD_ROOTFS_EXTERNAL} of=${SDCARD_EXTERNAL} conv=notrunc,fsync seek=${PART_START} bs=512

    rm ${SDCARD_ROOTFS_EXTERNAL}
}

addtask do_cleaned_firmware_image after do_image_complete before do_populate_lic_deploy

addtask rootfs_firmware after do_rootfs before do_image

