# Copyright (C) 2019-2023 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>

SUMMARY = "Shell profiles"
DESCRIPTION = "Installs profiles for user root"
LICENSE = "CLOSED"

inherit allarch

FILES:${PN} += "${ROOT_HOME}"

do_unpack[noexec] = "1"
do_fetch[noexec] = "1"
do_patch[noexec] = "1"
do_configure[noexec] = "1"

do_compile() {
  echo "export XDG_RUNTIME_DIR=~/.xdg" > ${B}/bashrc
  echo "alias ll='ls -lF --time-style=long-iso'" >> ${B}/bashrc
  echo "source ~/.bashrc" > ${B}/profile
}

do_compile:mpxs32g() {
  echo "alias ll='ls -lF --time-style=long-iso'" >> ${B}/bashrc
  echo "source ~/.bashrc" > ${B}/profile
}

do_install() {
  install -d ${D}${ROOT_HOME}
  install -d -m 0700 ${D}${ROOT_HOME}/.xdg

  install -m 0644 ${B}/bashrc ${D}${ROOT_HOME}/.bashrc
  install -m 0644 ${B}/profile ${D}${ROOT_HOME}/.profile
}

do_install:mpxs32g() {
  install -d ${D}${ROOT_HOME}

  install -m 0644 ${B}/bashrc ${D}${ROOT_HOME}/.bashrc
  install -m 0644 ${B}/profile ${D}${ROOT_HOME}/.profile
}

do_clean() {
  for p in ${B}/bashrc ${B}/profile; do
    if [ -f ${p} ]; then rm -f ${p}; fi
  done
}

do_clean:mpxs32g() {
  for p in ${B}/bashrc ${B}/profile; do
    if [ -f ${p} ]; then rm -f ${p}; fi
  done
  rm -f ${B}/99-rtc1.rules
}
