# Copyright 2018-2019 NXP
# Generic recipe to create a boot flash image
# We also want to permit flash image generation.
# We are using the new flashimage class to get a full flash image
#
# <Heinz.Wrobel@nxp.com>
# adapted for Microsys use by
# <falk.schoenfeld@microsys.de>
#
# We *only* want to build a basic flashimage, nothing else.
# Yocto requires us to set IMAGE_FSTYPES prior to inheriting the
# image class.

LICENSE = "CLOSED"

IMAGE_FSTYPES = "ext4 cpio"

# from meta-alb-sdk/recipes-fsl/images/fsl-image-emptyrootfs.inc
# We want to use the image mechanism without filling a rootfs to save space and time.
# So we use a simple trick to make do_rootfs nearly nothing.

IMAGE_LINGUAS = ""
IMAGE_INSTALL = ""
PACKAGE_INSTALL = ""

fakeroot python do_rootfs:prepend () {
    d.setVar("IMAGE_PREPROCESS_COMMAND", "")
    d.setVar("IMAGE_POSTPROCESS_COMMAND", "")
}

inherit image

ROOTFS_BOOTSTRAP_INSTALL = ""
KERNELDEPMODDEPEND = ""
KERNEL_DEPLOY_DEPEND = ""

IMAGE_FEATURES:remove = "ssh-server-openssh"

# TODO
# require ${@bb.utils.contains('DISTRO_FEATURES', 'pfe', 'recipes-fsl/images/fsl-image-pfe.inc', '', d)}

# do_prepare_recipe_sysroot[depends] += "${@bb.utils.contains('DISTRO_FEATURES', 'verifiedboot', 'fsl-image-itb:do_mkimage', '', d)}"

# Userspace support for QSPI Flash under Linux for S32CC platforms
IMAGE_INSTALL:append:s32cc = " mtd-utils "

# do_image_cpio:append(){
#     ln -s ${FLASHIMAGE_ROOTFS_FILE} ${DEPLOY_DIR_IMAGE}/
# }