# Copyright (C) 2020-2025 MicroSys Electronics GmbH
# Author: Kay Potthoff <kay.potthoff@microsys.de>

inherit microsys

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:"
PATCHTOOL = "git"
PATCH_COMMIT_FUNCTIONS = "1"

# BRANCH = "release/bsp42.0-6.6.32-rt"
# SRCREV = "49d9f8bb25e0de43587acd9238949752f914a6d2"
SRC_URI:append = " file://linux.patch"

python do_patch:prepend() {
    if d.getVar('PATCHTOOL') == 'git':
        srcsubdir = d.getVar('S')
        bb.process.run('git config am.threeWay true', cwd=srcsubdir)
        bb.process.run('git config am.keepcr true', cwd=srcsubdir)
        bb.process.run('git config apply.whitespace fix', cwd=srcsubdir)
        bb.process.run('git config apply.ignoreWhitespace change', cwd=srcsubdir)
}

PLATFORM ?= "${MACHINE}"
ITS_FILE ?= "${@microsys_get_its_file(d)}"

SCMVERSION = "n"

do_compile[depends] += "u-boot-tools-native:do_populate_sysroot"

INSTALL_MOD_PATH = "${D}"
EXTRA_OEMAKE += 'INSTALL_MOD_PATH="${D}"'

KERNEL_IMAGETYPE = "Image.gz"

KERNEL_MODULE_AUTOLOAD:mpxs32g += "\
    nxp \
"

LINUX_TOOLS ?= "leds usb"

do_compile:append() {

    its_file=${ITS_FILE} # ${S}/kernel-${PLATFORM}.its

    if [ ! -f ${its_file} ]; then
        its_file = ${S}/kernel-mpxls10xx.its
    fi
    default="            default = \"${ITS_DEVICETREE_CFG}\";"
    if [ -n "${ITS_DEVICETREE_CFG}" ]; then
        sed -e "s/^ *default *=.*$/${default}/g" ${its_file} > ${B}/kernel-${PLATFORM}.its
    else
        cp ${its_file} ${B}/kernel-${PLATFORM}.its
    fi

    # Build Linux tools

    cd ${S}
    oe_runmake -C tools/ ${LINUX_TOOLS}

    cd ${B}
    mkimage -f kernel-${PLATFORM}.its fitImage.itb
}

do_install:append() {

    install -m 0755 -o root -g root -d ${D}/boot
    install -m 0644 -o root -g root fitImage.itb ${D}/boot/fitImage-${KERNEL_VERSION}.itb
    ln -sf fitImage-${KERNEL_VERSION}.itb ${D}/boot/fitImage.itb

    #bbdebug 1 "Installing fitImage-${KERNEL_VERSION}.itb\n"
    #install -d ${DEPLOY_DIR_IMAGE}
    #install -m 0644 ${D}/boot/fitImage-${KERNEL_VERSION}.itb ${DEPLOY_DIR_IMAGE}/fitImage-${KERNEL_VERSION}.itb
    #ln -sf fitImage-${KERNEL_VERSION}.itb ${DEPLOY_DIR_IMAGE}/fitImage.itb

    # Install Linux tools
    # (the Makefile in tools/ doesn't install the tools with root ownership
    # therefore, we're doing this manually here)

    install -d -o root -g root ${D}/usr/bin

    if ${@bb.utils.contains('LINUX_TOOLS', 'gpio', 'true', 'false', d)}; then
       install -m 0755 -o root -g root ${S}/tools/gpio/lsgpio ${D}/usr/bin
       install -m 0755 -o root -g root ${S}/tools/gpio/gpio-event-mon ${D}/usr/bin
       install -m 0755 -o root -g root ${S}/tools/gpio/gpio-hammer ${D}/usr/bin
    fi

    if ${@bb.utils.contains('LINUX_TOOLS', 'led', 'true', 'false', d)}; then
        install -m 0755 -o root -g root ${S}/tools/leds/uledmon ${D}/usr/bin
    fi

    if ${@bb.utils.contains('LINUX_TOOLS', 'usb', 'true', 'false', d)}; then
        install -m 0755 -o root -g root ${S}/tools/usb/testusb ${D}/usr/bin
    fi

    if ${@bb.utils.contains('LINUX_TOOLS', 'spi', 'true', 'false', d)}; then
       install -m 0755 -o root -g root ${S}/tools/spi/spidev_test ${D}/usr/bin
    fi

    rm -fr ${D}/boot/vmlinu*
}

do_deploy:append() {
    bbdebug 1 "Deploying fitImage-${KERNEL_VERSION}.itb\n"
    install -m 0644 ${D}/boot/fitImage-${KERNEL_VERSION}.itb ${DEPLOYDIR}/fitImage-${KERNEL_VERSION}.itb
    ln -sf fitImage-${KERNEL_VERSION}.itb ${DEPLOYDIR}/fitImage.itb
}

FILES:${KERNEL_PACKAGE_NAME}-image += "/boot"
FILES:${PN} += "/boot"

PACKAGES += "${PN}-tools"

FILES:${PN}-tools += " \
   /usr/bin \
"

INSANE_SKIP:${PN}-tools = "ldflags debug-files"
