# Copyright (C) 2019-2025 MicroSys Electronics GmbH
# Author: Falk Schoenfeld <falk.schoenfeld@microsys.de>

SUMMARY = "systemd-networkd config file to disable DHCP"
DESCRIPTION = "Adds a config file for systemd-networkd which prevents DHCP on the ether type (eth, pfe) interfaces"
LICENSE = "CLOSED"
SECTION = "console/network"

inherit features_check
REQUIRED_DISTRO_FEATURES = "dhcp-disabled"

NETWORKCONF="20-dhcp-disabled.network"
SRC_URI += "file://${NETWORKCONF}"

do_patch[noexec] = "1"
do_configure[noexec] = "1"
do_compile[noexec] = "1"

do_install() {
  install -d ${D}${sysconfdir}/systemd/network
  install -m 0644 ${WORKDIR}/${NETWORKCONF} \
    ${D}${sysconfdir}/systemd/network/${NETWORKCONF}
}

FILES:${PN} += "${sysconfdir}/systemd/network/20-dhcp-disabled.network"
