# Copyright (C) 2020-2025 MicroSys Electronics GmbH
# Authors: Kay Potthoff <kay.potthoff@microsys.de>, Florian Aigner <florian.aigner@microsys.de>

inherit microsys

FILESEXTRAPATHS:prepend := "${THISDIR}/${PN}:"
PATCHTOOL = "git"
PATCH_COMMIT_FUNCTIONS = "1"

#URL    = "git://github.com/MicroSysElectronics/u-boot;protocol=https"
#BRANCH = "microsys-s32-bsp34.0"
#SRCREV = "9c4b68131c22338ebb31a7de91930d3f8ce01a8d"

#BRANCH = "release/bsp43.0-2022.04"
#SRCREV = "5a6f62071feb0615b51eb0b67120609cd46d95e3"
SRC_URI:append = " file://u-boot.patch"

# devtool wants to copy .config from here...
#B = "${WORKDIR}/${BPN}-${PV}"
DEVTOOL_DISABLE_MENUCONFIG = "1"

DEPENDS += "python-native"

DEPENDS:append = "${@bb.utils.contains('DISTRO_FEATURES', 'hse', ' hse-firmware ', '', d)}"

# Take care that HSE firmware is installed
# before do_patch() is executed:
do_patch[depends] += "${@bb.utils.contains('DISTRO_FEATURES', 'hse', "hse-firmware:do_install", '', d)}"
do_patch[deptask] += "${@bb.utils.contains('DISTRO_FEATURES', 'hse', "hse-firmware:do_install", '', d)}"

# BUILD_TYPE = "debug"
# EXTRA_OEMAKE += "LOG_LEVEL=50"
# EXTRA_OEMAKE:append = " CFLAGS+='-g -O0' CONFIG_DEBUG=y DEBUG=1"

python do_patch:prepend() {
    if d.getVar('PATCHTOOL') == 'git':
        srcsubdir = d.getVar('S')
        bb.process.run('git config am.threeWay true', cwd=srcsubdir)
        bb.process.run('git config am.keepcr true', cwd=srcsubdir)
        bb.process.run('git config apply.whitespace fix', cwd=srcsubdir)
        bb.process.run('git config apply.ignoreWhitespace change', cwd=srcsubdir)
        # Reset uboot repo to original state because patch step applies a commit
        bb.process.run('git reset --hard ' + d.getVar('SRCREV'), cwd=srcsubdir)
}
# Don't execute these two tasks, because
# the job is done in do_patch::append() above:
#do_add_hse_fw_path[noexec] = "1"
#do_merge_delta_config[noexec] = "1"
