# This class is meant to build a binary flash image for the user that will directly lead to a bootable system.
# Due to the need for some flexibility in naming, a custom file is used here because Yocto does not support overriding
# of classes like it does for recipes unfortunately.
# On integration of an SDK, the changes here should be properly merged.
#
# Heinz Wrobel <Heinz.Wrobel@nxp.com>

# Modified for microsys use by 
# Falk Schönfeld <falk.schoenfeld@microsys.de>
 
inherit image_types_fsl_flashimage
AUTO_IMG_NAME = "microsys-image-auto-s32g399ar5sbc3"

DEPENDS += " microsys-image-emptyrootfs"
IMAGE_TYPES += " microsys_flashimage"

FLASHIMAGE_ROOTFS = "microsys-image-emptyrootfs"

# imported as necessary from meta-alb/meta-alb-qoriq/conf/machine/include/lxflashmap.inc
FLASHIMAGE_RESET_OFFSET  ?= "0x00000000"

FLASHIMAGE_UBOOT_OFFSET	 ?= "0x00100000"
FLASHIMAGE_FIP_OFFSET ?= "${FLASHIMAGE_UBOOT_OFFSET}"

FLASHIMAGE_KERNEL_OFFSET ?= "0x01000000"
FLASHIMAGE_ROOTFS_OFFSET ?= "0x02000000"
FLASHIMAGE_DTB1_OFFSET   ?= "0x03000000"
FLASHIMAGE_DTB2_OFFSET   ?= "0x03020000"

FLASHIMAGE_PFE_OFFSET    ?= "0x03040000"
FLASHIMAGE_PFE_FILE      ?= "s32g_pfe_class.fw"

FLASHIMAGE_UBOOT_FILE = 'u-boot.bin-qspi'

FLASHIMAGE_ROOTFS_FILE = "${FLASHIMAGE_ROOTFS}-${MACHINE}.cpio"

SDCARD_ROOTFS_EXTRA1 = "microsys-image-auto"
SDCARD_BOOT_EXTRA1_FILE = "${FLASHIMAGE}"
SDCARD_ROOTFS_EXTRA1_SIZE = "80000"

# overwritten to use bbnote for debugging offsets, no functional changes
generate_flashimage_entry() {
        bbnote "Generating flash image entry $2: $1 at $3"
        file="$1"
        if [ -n "${file}" ]; then
                file="${DEPLOY_DIR_IMAGE}/${file}"
                rawimage_generate_entry "${file}" "${FLASHIMAGE}" "$2" "$3"
        fi
}

# modified to have two DTBs and pfe file
generate_microsys_flashimage() {
        generate_flashimage_entry "${FLASHIMAGE_RESET_FILE}"  "FLASHIMAGE_RESET_OFFSET"  "${FLASHIMAGE_RESET_OFFSET}"
        generate_flashimage_entry "${FLASHIMAGE_FIP_FILE}"    "FLASHIMAGE_FIP_OFFSET"    "${FLASHIMAGE_FIP_OFFSET}"
        generate_flashimage_entry "${FLASHIMAGE_KERNEL_FILE}" "FLASHIMAGE_KERNEL_OFFSET" "${FLASHIMAGE_KERNEL_OFFSET}"
        generate_flashimage_entry "${FLASHIMAGE_ROOTFS_FILE}" "FLASHIMAGE_ROOTFS_OFFSET" "${FLASHIMAGE_ROOTFS_OFFSET}"
        generate_flashimage_entry "${FLASHIMAGE_DTB1_FILE}"   "FLASHIMAGE_DTB1_OFFSET"   "${FLASHIMAGE_DTB1_OFFSET}"
        generate_flashimage_entry "${FLASHIMAGE_DTB2_FILE}"   "FLASHIMAGE_DTB2_OFFSET"   "${FLASHIMAGE_DTB2_OFFSET}"
        generate_flashimage_entry "${FLASHIMAGE_PFE_FILE}"    "FLASHIMAGE_PFE_OFFSET"    "${FLASHIMAGE_PFE_OFFSET}"
        generate_flashimage_entry "${FLASHIMAGE_EXTRA1_FILE}" "FLASHIMAGE_EXTRA1_OFFSET" "${FLASHIMAGE_EXTRA1_OFFSET}"
}

# modified to
# - use different generate_flashimage
# - link specific dependency files in the process
IMAGE_CMD:microsys_flashimage () {
        # we expect image size in MiB
        FLASH_IBS="1048576"

        # link qspi and cpio images, otherwise they will not be found
        # rm -rf ${DEPLOY_DIR_IMAGE}/${FLASHIMAGE_ROOTFS_FILE}

        CPIO_FILE="$(ls ${DEPLOY_DIR_IMAGE}/${FLASHIMAGE_ROOTFS}-${MACHINE}-*.rootfs.cpio 2>/dev/null || true)"
        if [ -n "${CPIO_FILE}" ]; then
        #     bbwarn "Found the CPIO file in the default deploy dir"
            ln -sf "${CPIO_FILE}" ${DEPLOY_DIR_IMAGE}/${FLASHIMAGE_ROOTFS_FILE}
        else
            #somehow this behaves differently when running in the customer docker, so steal file from emptyrootfs directly
            PATH_EMPTYROOTFS="$(echo ${WORKDIR} | sed -e 's+image-auto.*+image-emptyrootfs/1.0-r0/deploy-microsys-image-emptyrootfs-image-complete/+g')"
        #     bbwarn "Searching CPIO file in ${PATH_EMPTYROOTFS}\n$(ls -l ${PATH_EMPTYROOTFS})"

            CPIO_FILE="$(ls ${PATH_EMPTYROOTFS}/${FLASHIMAGE_ROOTFS}-${MACHINE}-*.rootfs.cpio 2>/dev/null || true)"
        fi

        ln -sf "${CPIO_FILE}" ${DEPLOY_DIR_IMAGE}/${FLASHIMAGE_ROOTFS_FILE}

        ln -sf "${FLASHIMAGE_DEPLOYDIR}/${IMAGE_LINK_NAME}.qspi" ${DEPLOY_DIR_IMAGE}/

        if [ -z "${FLASHIMAGE_SIZE}" ]; then
                if [ -n "${FLASHIMAGE_ROOTFS_FILE}" ]; then
                        FLASHIMAGE_ROOTFS_SIZE=$(stat -L -c "%s" "${FLASHIMAGE_ROOTFS_FILE}")
                        FLASHIMAGE_ROOTFS_SIZE_EXTRA=$(echo "$FLASHIMAGE_ROOTFS_SIZE+(16-$FLASHIMAGE_ROOTFS_SIZE%16)"| bc)
                        FLASHIMAGE_SIZE=$(expr ${FLASHIMAGE_ROOTFS_OFFSET} + $FLASHIMAGE_ROOTFS_SIZE_EXTRA)
                        # computed size is not in MiB, so adjust the block size
                        FLASH_IBS="1"
                else
                        bberror "FLASHIMAGE_SIZE is undefined. To use the flash image it needs to be defined in decimal MiB units."
                        exit 1
                fi
        fi

        FLASHIMAGE_SIZE_D=$(printf "%s * %s\n" ${FLASHIMAGE_SIZE} ${FLASH_IBS} | bc)
        rawimage_initutils "flash image" "${FLASHIMAGE_BANK4}" ${FLASHIMAGE_SIZE_D};

        # Initialize the image file with all 0xff to optimize flashing
        cd ${FLASHIMAGE_DEPLOYDIR}

        dd if=/dev/zero ibs=$(printf "%d" ${FLASHIMAGE_SIZE_D}) count=1 | tr "\000" "\377" > "${FLASHIMAGE}"

        generate_microsys_flashimage
        cd -
}
