Copyright (C) 2020-2025 MicroSys Electronics GmbH

# Release Notes for MPXS32G Modules

## Supported Platforms

- S32G274AR2SBC3 with MPXS32G274A (Rev. 2/4) on carrier CRXS32G (Rev. 3)
- S32G274AR5SBC3 with MPXS32G274A (Rev. 5/6) on carrier CRXS32G (Rev. 3)
- S32G399AR5SBC2/3 with MPXS32G399A (Rev. 5/6) on carrier CRXS32G (Rev. 2/3)

## Limitations

- SJA1124: no support implemented (LIN-controller)
- Linux ETH0: Autonegotiation is not successful in hardware. It will always use 1GBit.
              Autonegotiation works in UBoot.

## Notes
- SGMII connection will attempt to use 2.5GBit in this version.
  This should not cause issues on 1GBit only devices, but changes output of some eth toolings.

## Yocto

A complete and actual list can be found in the poky distribution at
`poky/meta-poky/conf/distro/poky.conf`
and then check the variable `SANITY_TESTED_DISTROS`.

## Change History

### 7.4.1 2025-11-05

- Meta
  - added support for changing maximum temperature threshold in
    - MPXS32G274A (Rev 5/6)
    - MPXS32G399G (Rev 5/6)
  - fixed sja initialization error


### 7.4.0 2025-09-26

based on Automotive BSP43.0

- ATF    2.10.7-7.4.0
- U-Boot 2022.04-7.4.0
- Linux  6.6.52-7.4.0
- Meta
  - fixed db build
  - switched to new sdcard and qspi image schemes
  - updated pfe fw version to 1.10.0

### 7.3.3 2025-02-07

based on Automotive BSP42.0

- ATF 2.10-7.3.3
- U-Boot 2022.04-7.3.3:
    - Revert change to HS200 speed
- Linux 6.6.32-7.3.3
- Meta
    - Add prints to notify about not set NXP Firmware locations

### 7.3.2 2025-01-31

based on Automotive BSP42.0

- ATF 2.10-7.3.2:
    - Devicetree changes for PFE MAC and microcontroller based reset
- U-Boot 2022.04-7.3.2:
    - Allow MMC speed changes via command line
    - Disable protection for environment variables intended to get changed
    - Handle I2C drivers without fixed operations to avoid crashes
    - Fixing serdes command and related hwconfig syntax
    - reset is being triggered by microcontroller on modules using microcontroller
    - PFE MAC addresses are taken from eeprom, not from PFE
    - Fixing CRC calculation and limits for to big environments (above 7.5kB)
- Linux 6.6.32-7.3.2
    - Increased printk log buffer to avoid lost error messages
    - Handle race condition between shutdown of PFE and GMAC
    - Add additional network drivers
    - Removal of USB debugging prints
- Meta
    - Fixed HSE build issues for S32G3


### 7.3.1: 2024-12-19

based on Automotive BSP42.0

- ATF 2.10-7.3.1:
    - Update from previous NXP mainline 2.5
- U-Boot 2022.04-7.3.1:
    - Update from previous NXP mainline 2020.04
    - Added GPT partitioning
    - Added "serdes" command to switch between the modes and do a reset:
        - 1GBit + M2 support
        - 2.5GBit without M2 support
    - Supports pfe0 in case SJA Firmware is loaded from external memory before.
    - Usage of HS200 speed on MPX revisions 5 and upwards.
- Linux 6.6.32-7.3.1
    - Update from previous NXP mainline 5.15.85
    - Update of SJA Firmware to 1.2.4
    - Fixed 2.5 Gbit SJA uplink support for carrier rev3
- Meta
    - Added new way to integrate NXP firmware as a zip file or git repo.
    - Added required patchfiles for NXP metalayer in "patches" directory.

### 6.2.8: 2024-08-12

based on Automotive BSP36.0

Removed S32G274AR6SBC3 as platform.
Use S32G274AR5SBC3 as replacement.

- ATF 2.5-6.2.8:
    - removed R6
- U-Boot 2020.04-6.2.8:
    - removed R6
    - EEPROM detection for R5 and R6 (#5321)
- Linux 5.15.85-6.2.8
    - removed R6

### 6.2.7: 2024-06-14

based on Automotive BSP36.0

- support for MPXS32G274A Rev. 6
- removed support for HSE
- ATF 2.5-6.2.7
- U-Boot 2020.04-6.2.7
- Linux 5.15.85-6.2.7

### 6.2.6: 2024-05-15

based on Automotive BSP36.0

- Support for HailoRT PCI cards
- ATF 2.5-6.2.6
	+ fixed maximum frequency for SD/eMMC to 20MHz
- U-Boot 2020.04-6.2.5
- Linux 5.15.85-6.2.5

### 6.2.5: 2024-03-21

based on Automotive BSP36.0

- ATF 2.5-6.2.5
- U-Boot 2020.04-6.2.5
- Linux 5.15.85-6.2.5
- new machines S32G399AR5SBC2/3 added

### 6.2.4: 2023-12-20

based on Automotive BSP36.0

- U-Boot 2020.04-6.2.6:
    - disabled RGMII clocking for SerDes connections on PHYs
    - enabled feature "mmc rst_n_function"

### 6.2.4: 2023-12-20

based on Automotive BSP36.0

- U-Boot 2020.04-6.2.4:
    - disabled RGMII clocking for SerDes connections on PHYs
    - enabled feature "mmc rst_n_function"

### 6.2.3: 2023-12-01

based on Automotive BSP36.0

- U-Boot 2020.04-6.2.3:
    - fixed QSPI flash not detected in Linux
      when booting from QSPI flash

### 6.2.2: 2023-07-20

based on Automotive BSP36.0

- Support for High Security Engine (HSE) added
- HSE firmware version 1.0.5
- Fixed some kernel crashes caused by PFE kernel module
- new machine S32G274AR5SBC3 added

### 6.2.1: 2023-05-15

based on Automotive BSP36.0

- Linux 5.15.85-6.2.1
     - fixed QSPI flash not detected in Linux

### 6.2: 2023-04-20

based on Automotive BSP36.0

- base on Yocto Poky release 4.0.5 (kirkstone)
- Linux 5.15.85-6.2
- ATF 2.5-6.2
- U-Boot 2020.04-6.2
- PFE firmware version 1.6.0
- LLCE 1.0.5 QLP1
- SJA1110: firmware v1.0.9

### 6.1.1: 2023-03-24

- fixed 1Gb connection to SJA1110 through PFE0

### 6.1: 2023-03-06

based on Automotive BSP35.0

- ATF 2.5-6.1
- U-Boot 2020.04-6.1
- Linux 5.15.73-6.1
- PFE firmware version 1.5.0
- LLCE 1.0.5 QLP1
- SJA1110: firmware v1.0.9

### 5.2.6: 2023-02-16

U-Boot 2020.04-5.2.6
- added 'product_info'-field to mac-command

### 5.2.5: 2022-12-05

Maintenance release

### 5.2.4: 2022-11-29

U-Boot 2020.04-5.2.4
- enabled support for USB-controller
- downported PCIe-fixes from BSP35.0

Known issue: There are PCIe-cards that are not recognized in U-Boot.
      This is an issue of the PCIe support in U-Boot.

ATF 2.5-5.2.4
- added entries for USB-controller in device tree

### 5.2.3: 2022-11-24

Linux 5.10.120-5.2.3
- enabled SGMII AN on GMAC0

U-Boot 2020.04-5.2.3
- enabled AN on all SGMII interfaces

### 5.2.2: 2022-11-21

Linux 5.10.120-5.2.2
- S32G274ASBC2/3: fixed phy-mode for PFE0

U-Boot 2020.04-5.2.2
- S32G274ASBC2/3: fixed SerDes mode switch

### 5.2.1: 2022-11-16

Linux 5.10.120-5.2.1
- fixed pin configuration for network device can1

Note: MicroSys' repositories of arm-trusted-firmware,
      u-boot, and linux are now hosted on GITHub.
      The link is
      [GITHub MicroSys Electronics](https://github.com/MicroSysElectronics)

### 5.2: 2022-10-26

based on Automotive BSP34.0

- ATF 2.5-5.2
- U-Boot 2020.04-5.2
- Linux 5.10.120-5.2
- PFE firmware version 1.4.0
- LLCE 1.0.4 HF1
- SJA1110: firmware v1.0.9

### 5.1: 2022-10-24

based on Automotive BSP33.0

- ATF 2.5-5.1
- U-Boot 2020.04-5.1
- Linux 5.10.109-5.1
- PFE 1.3.0
- SJA1110: firmware v1.0.9

### 5.0.6: 2022-10-06

- ATF 2.5-5.0.6
    - fixed #4772 "BSP doesn't boot on all modules".
      I2C clocking was corrected
- U-Boot 2020.04-5.0.6
- Linux 5.10.90-5.0.6

### 5.0.5: 2022-08-05

- ATF 2.5-5.0.5
  Fixes for ticket #4583: SD-card boot problem
     - delay of 1ms before sending a command to SD-card
     - wait for clock stable when changing speed
     - set maximum speed to 20MHz (instead of 26MHz)
- Linux 5.10.90-5.0.5
     - S32G274ASBC3: set speed of I2C2 to 100KHz

### 5.0.4: 2022-07-20

- U-Boot 2020.04-5.0.4
  MAC-addresses from environment are programmed into EEPROM
  if the EEPROM is empty/uninitialized.

### 5.0.3: 2022-06-15

### 5.0.2: 2022-06-03

- Linux 5.10.90-5.0.2
        - disabled IRQs for TMP451 and PCF85263
- U-Boot 2020.04-5.0.2
    - UART speeds higher than 115200 baud can be configured
    - environment variable pfengfw is now dynamically set to
      PFE firmware image on current boot media

### 5.0.1: 2022-05-17

- Linux 5.10.90-5.0.1
- U-Boot 2020.04-5.0.1
- U-Boot: integrated command 'mac' for managing MAC-addresses

### 5.0: 2022-05-04

Release based on Automotive BSP32.0

- Linux 5.10.90-5.0
- U-Boot 2020.04-5.0
- ATF 2.5-5.0
- PFE 0.9.7 with firmware version 1.2.0

### V4.4.6: 2022-03-14

Disabled ATF-boot in this release (scheduled for future BSP).

- U-Boot 2020.04-4.4.6
        - Fixed location of PFE FW
- Linux 5.10.41-4.4.6
       - configured IRQ for GPIO controller gpio@43

### V4.4.5: 2022-02-25

- Linux 5.10.41-4.4.5
     - implemented workaround for kernel crash when
       QSPI clock is changed

### V4.4.4: 2022-02-02

- LLCE: Linux: downport of fixes from BSP32.0 development branch
- U-Boot 2020.04-4.4.4
- Linux 5.10.41-4.4.4

### V4.4.3: 2022-01-24

- U-Boot 2020.04-4.4.3
- Linux 5.10.41-4.4.3

### V4.4.2: 2022-01-19

- Fixed sporadic kernel panic regarding Ethernet interfaces
- U-Boot 2020.04-4.4.2
- Linux 5.10.41-4.4.2

### V4.4.1: 2022-01-11

- Added platform S32G274ASBC3
- U-Boot 2020.04-4.4.1
- Linux 5.10.41-4.4.1

### V4.4: 2022-01-03

- Maintenance update to Automotive BSP31.0
    - U-Boot 2020.04-4.4
    - Linux 5.10.41-4.4
    - Yocto 3.2.4 (gatesgarth)
    - PFE 0.9.6
    - LLCE 1.0.3 CD1 D2111

### V4.3.3: 2021-11-15

- fixed SerDes/XPCS setup in Linux
    - PHY lane number and XPCS ID has been mixed up
    - fixed: PFE module overwrites speed with duplex value
- U-Boot 2020.04-4.3.2
- Linux  5.10.41-4.3.2

### V4.3.2: 2021-10-21

- GMAC via SGMII is now working in Linux
- U-Boot 2020.04-4.3.1
- Linux  5.10.41-4.3.1
- NXP support case #00421736 solved:
  llce: Kernel errors from llcecan driver

### V4.3.1: 2021-10-06

- Added fix to build & install sja1110 package to the root file system

### V4.3: 2021-09-16

- Maintenance update to Automotive BSP30.0
    - U-Boot 2020.04-4.3
    - Linux 5.10.41-4.3
    - Yocto 3.2.1 (gatesgarth)
    - PFE 0.9.5

### V4.2.7: 2021-09-08

- U-Boot 2020.04-4.2.2
- Linux 5.4.69-4.2.6

### V4.2.6: 2021-08-20

- U-Boot 2020.04-4.2.1
- Linux 5.4.69-4.2.5

### V4.2.5: 2021-07-30

- Linux 5.4.69-4.2.4
  Enabled 'sar-adc' for S32G274ASBC2 platform

### V4.2.4: 2021-07-29

- Linux 5.4.69-4.2.3
  Fixed prescaler parameter check for non-FD standard

### V4.2.3: 2021-07-26

- S32G274ASBC2:rev3: Updated SJA1110 Firmware Images
  Changed SJA1110 Configuration for 1GB-T1 from auto-speed to 1GBit fixed

### V4.2.2: 2021-07-05

- Linux 5.4.69-4.2.2
  Fixed issue with extended IDs for LLCE CAN busses

### V4.2.1: 2021-06-24

- fixed firmware upload for SJA1110
- Linux 5.4.69-4.2.1

### V4.2: 2021-06-18

- Maintenance update to Automotive BSP29.0
    - U-Boot 2020.04
    - Linux 5.4.69
    - Yocto 3.2.1 (gatesgarth)
    - PFE 0.9.4
    - LLCE 1.0.1 D2105
- Note: update the U-Boot environment to default when upgrading to BSP29.0 release.

### V4.1.5: 2021-06-15

- S32G274ASBC2: Updated SJA1110 Firmware Images
  Changed SJA1110 Configuration for 1GB-T1 from Auto-speed to 1GBit Fixed.

### V4.1.4: 2021-05-10

- S32G274ASBC: fixed: CAN tranceivers in stand-by
  The CAN tranceivers for the CAN busses were in stand-by mode.

### V4.1.3: 2021-04-13

- BSP28.0: support for S32G274ASBC

### V4.1.2: 2021-04-12

- Fixed stand-by mode of CAN tranceivers (S32G274ASBC2)
  The CAN tranceivers are now out of sleep state and are functional.

### V4.1.1: 2021-03-25

- Updated SJA1110 firmware images
  There are now two firmware images provided:
     - one for the M.2 configuration
     - one for the 2G5 configuration

### V4.1: 2021-03-22

- Update to automotive BSP28.0
    - U-Boot 2020.04
    - Linux 5.4.69
    - Yocto 3.2.1 (gatesgarth)
    - PFE 0.9.3
    - LLCE 0.9.1
    - Firmware support for SJA1110 TSN switch
    - QSPI boot of U-Boot

### V3.1.4: 2021-02-25

- Added platform S32G274ASBC2 with
     - MPXS32G274A Rev. 2
     - CRXS32G Rev. 2

### V3.1.3: 2021-02-02

- Based on Automotive BSP27.0 from NXP
- U-Boot: added 64bit support for PCIe (patches from NXP)

### V3.1.2: 2021-01-18

- Based on Automotive BSP27.0 from NXP
- U-Boot: PFE2: Fixed: Invalid operation mode - rgmii

### V3.1.1: 2020-12-16

- Based on Automotive BSP27.0 from NXP
- Linux: fixed initialization of FXL6408 GPIO-expander.
  The initialization of the I/O-direction register is now the
  last action in the driver. This avoids glitches when switching
  an input pin to output.

### V3.1: 2020-12-08

- Based on Automotive BSP27.0 from NXP:
    - U-Boot 2020.04
    - Linux 5.4
    - Yocto 3.0 (zeus)
    - PFE 0.9.2
    - Firmware support for SJA1110 TSN switch
    - QSPI boot of U-Boot

Note: when booting from QSPI and the PFE firmware should be loaded this can
only be done from MMC. The U-Boot environment variable 'pfengfw' has to be
set to point to the location:

`(U-Boot) => setenv pfengfw 'mmc@0:1:s32g_pfe_class.fw'`

### V2.0: 2020-09-29

- Based on Automotive BSP26.0 from NXP:
    - U-Boot 2020.04
    - Linux 5.4
    - Yocto 3.0 (zeus)
    - PFE 0.9.0

### V1.0: 2020-09-23

- Based on Automotive BSP25.2 from NXP:
    - U-Boot 2019.04
    - Linux 4.19
    - Yocto 3.0 (zeus)
    - PFE 0.8.0
- s32g274asbc: Initial version
