Copyright (C) 2020-2025 MicroSys Electronics GmbH

# Yocto Build Setup

> **__&#9888; NOTE:__** This guide has been superseded by the *SBC-S32G Software Enablement Guide* distributed alongside this code.
> Please refer to it for using a much simpler build process using a sample docker container.
> This readme is kept for documentation purposes only and will be removed in future versions.

This text describes how to setup a Yocto build environment for the MicroSys Board Support Package (BSP).

For more recent builds, adapt the scripting on your own.

You can also use the Docker image provided as part of the Software enablement guide.
It handles an SBC build for all supported platforms with minimal integration effort.
Dockerfile and guide are delivered as part of our hardware package.
Please get in touch with us in case you don't have it yet.

## Download and Clone NXP's Yocto Repository

### Presumptions

BSP43.0 is based on Yocto Poky 4.0.21.

You need a build host that is supported by this Yocto release.

Please check the documentation at
[System Requirements Poky 4.0.21](https://docs.yoctoproject.org/4.0.21/ref-manual/system-requirements.html).

#### Update the Manifest

* This step is optional.
* Also note that this step is for experts.

You can update the version of Poky to a later version of the same Yocto release
via manipulating the manifest.
Note that you can't update to another Yocto release, you can only update to the
latest version of the same release!

##### Preparation

Take care that the following packages are installed on your build system:

* python3-argcomplete
* python3-cppheaderparser
* python3-netifaces
* python3-tqdm
* python3-aspy.yaml
* python3-distlib
* python3-pyzmq
* python3-verboselogs
* python3-cfgv
* python3-future
* python3-zipp
* python3-identify
* python3-zmq

##### Update

1. Clone the manifest repository:
    ``` bash
    git clone https://github.com/nxp-auto-linux/auto_yocto_bsp
    cd auto_yocto_bsp
    git checkout release/bsp43.0
    ```
2. Edit the file default.xml and change the content of the attribute
   'revision' of the project 'poky'. This attribute denotes the commit hash
   of the Poky release. For example, the Poky 'kirkstone' version 4.0.18
   has the commit hash `31751bba1c789f15f574773a659b8017d7bcf440`.

	Example snippet from default.xml:

	``` xml
	...
	<project name="poky" path="sources/poky" remote="yocto" revision="2e79b199114b25d81bfaa029ccfb17676946d20d"/>
	...
	```

	This should be changed to:

	``` xml
	...
	<project name="poky" path="sources/poky" remote="yocto" revision="31751bba1c789f15f574773a659b8017d7bcf440"/>
	...
	```

3. Commit the changes:

    ``` bash
    git commit -a -m "kirkstone 4.0.21"
    ```

4. Tell `repo` to take the fixed manifest:

    ``` bash
    repo init --no-clone-bundle --depth=1 --manifest-url=file://[...]/auto_yocto_bsp --manifest-branch=release/bsp36.0 --manifest-name=file://[...]/auto_yocto_bsp/default.xml
    
    repo sync --current-branch --jobs=6 --fetch-submodules --fail-fast --no-clone-bundle --force-sync --no-manifest-update --auto-gc --manifest-name=file://[...]/auto_yocto_bsp/default.xml
    ```

    Important note: these two calls of repo replace the calls described in [Steps](###Steps) below.
    Note: the URL path needs to be fixed to the path where you have checked out the manifest.

Note that you have probably to check the system requirements again for the updated Poky version.
For release kirkstone 4.0.21 this is, i.e [System Requirements Poky 4.0.21](https://docs.yoctoproject.org/4.0.21/ref-manual/system-requirements.html).

### Known Build Issues

#### Openssl

When your build fails when building the Linux kernel with an error message regarding openssl/bio.h
then you need to install the openssl development package on your build machine.

Please check the documentation of the used Linux distribution how to do this.

Known package names are:

- Fedora:
    `# dnf install openssl-devel`
- CentOS:
    `# yum install openssl-devel`
- Ubuntu:
    `# sudo apt-get install libssl-dev`

#### Ownership

Be aware that Yocto cannot build with administrator rights (root-user).
You need a "normal" user account for the builds.

### Steps

1. Install 'repo' if not already done:

    ``` bash
    # mkdir -p /usr/local/bin
    # export PATH=${PATH}:/usr/local/bin
    # curl https://storage.googleapis.com/git-repo-downloads/repo > /usr/local/bin/repo
    # chmod a+x /usr/local/bin/repo
    ```

    > **__&#9888; NOTE:__** You might need administrator rights (root) to execute these commands, or
          alternatively if you are registered as sudo-user you can use `sudo`.

    > **__&#9888; NOTE:__** If the directory `/usr/local/bin` already exists and is part of your
          `PATH` variable, you can omit the first two commands.

2. Create and go to a directory of your choice.
    Your home directory would be a good place.
    Note: A Yocto build produces tons of temporary files.
        Ensure that you have enough disk space, approximately 100GB!

3. Execute the following commands:

    ``` bash
    repo init --no-clone-bundle -u https://github.com/nxp-auto-linux/auto_yocto_bsp -b release/bsp43.0
    
    repo sync --force-sync --no-clone-bundle
    ```

After executing these two commands you should have a directory called `sources/` and a script called `nxp-setup-alb.sh` in your current directory.

## Install MicroSys' Layer for S32G

1. Go to the directory `sources/` and copy or unpack the layer `meta-microsys-auto` there.
    You should then have a directory with the layer name in `sources/`.

    > **__&#9888; NOTE:__** The name of the top directory in the TAR-ball or ZIP-file could contain
    a revision in its name. In this case rename it to `meta-microsys-auto`.

2. Source the script `nxp-setup-alb.sh`:  
    ``` bash
    . nxp-setup-alb.sh -e meta-microsys-auto -m s32g274ar2sbc3 -D microsys-auto
    ```

You are now ready for starting to build the `s32g274ar2sbc3` image.

3. Start the build for the image `microsys-image-auto`:
    ```
    bitbake microsys-image-auto
    ```

## Hailo Layer

This step is optional.
You need this step only if you plan to use support for HailoRT PCI modules.

1. Go to the directory `sources/`

2. Install the layer:

    ``` bash
    git clone https://github.com/hailo-ai/meta-hailo.git
    ```
   Note: this creates the directory `meta-hailo/`

3. Checkout the appropriate version:

    ``` bash
    cd meta-hailo
    git checkout kirkstone
    ```

4. The Hailo packages will be built when you choose the distribution
   microsys-auto-hailo, i.e.:

    ``` bash
    . nxp-setup-alb.sh -e meta-microsys-auto -m s32g274ar2sbc3 -D microsys-auto-hailo
    ```

5. Now you need to added the contained layers to your conf/bblayers.conf file:

    ``` bash
    BBLAYERS += " [...]/meta-hailo/meta-hailo-accelerator \
                  [...]/meta-hailo/meta-hailo-libhailort"
    ```

   Note that you need to adjust the path to the path where you have installed
   the layer meta-hailo.

## Program QSPI Flash with Bootloader

1. Boot from SD-card into the U-Boot prompt
2. Program the firmware image with:
    ```
    => run flash
    ```
3. Switch to QSPI boot media
   This can be done via using the onboard DIP-switch or
   you re-program the RCW in the EEPROM with:
    ```
    => run rcwqspi
    ```
Note that you probably have to update your U-Boot environment before performing these steps:

```
=> env default -f flash
=> env default -f flash_img
=> env delete kconfig
=> env save
```

## Program the PFE Firmware into QSPI

1. Boot from SD-card into the U-Boot prompt
2. Program the firmware image with:
    `=> run flashfw`

Note that you probably have to update your U-Boot environment before performing these
steps:

```
=> env default -f flashfw
=> env default -f flashfw_img
=> env default -f pfengfw
=> env delete kconfig
=> env save
```

## CAN Busses

The boards `s32g274ar2sbc3` and `s32g274ar2sbc3` have 18 CAN busses routed to external connectors.

## Interfaces

|Linux CAN interface|S32G Pins |
|-------------------|----------|
|can0               |CAN2      |
|can1               |CAN3      |
|llcecan0           |LLCE CAN0 |
|...                |...       |
|llcecan15          |LLCE CAN15|

## Configuration

The interfaces can be configured with the 'ip' command.

For `can0` and `can1` the following commands bring-up the interfaces:

    ``` bash
    ip link set can0 up type can bitrate 1000000

    ip link set can1 up type can bitrate 1000000
    ```

The LLCE CAN interfaces need, e.g. for `llcecan0`:

    ``` bash
    ip link set llcecan0 up type can bitrate 500000 dbitrate 5000000 fd on
    ```

### SJA1110 TSN Switch

The platforms `s32g274ar2sbc3/3` and `s399ar5sbc3` are equipped with a SJA1110 TSN switch.
The Linux kernel automatically uploads a fitting firmware image into the SJA1110 switch.
This upload mechanism requires the switch to be put into the serial download mode.
In order to do so, the DIP-switches 1 and 2 needs to be in the off position. 
This is the DIP-switch on the carrier CRXS32G with two switches in total.

## Notes for Software Developers

### Create Your Own Layer <span id="create-layer"/>

Before you start modifying recipes it is best when to create your own layer which
is supposed to contain your changes.

1. If not already done go to the build directory of the machine and call:
    `# . SOURCE_THIS`
    This configures and starts bitbake.
2. Go to the `sources/` directory and create your layer there:  
    `# bitbake-layers create-layer --priority 20 meta-mylayer`

    *Note 1:* because the priority of meta-microsys-auto is 12, it is recommended
    to choose a higher number as priority for your own layer (but less than 99).

    *Note 2:* It is good practice to prefix the layer name with `meta-`.

    *Note 3:* (Optional) You can remove the directory recipes-example in the
    directory `meta-mylayer/`.

3. Go to the build directory of the machine and add your new layer with:  
    `# bitbake-layers add-layer ../sources/meta-mylayer`

Now you are ready for modifying sources.

### Modifying U-Boot or Linux Kernel

You can modify the sources of U-Boot using the Yocto tool devtool. 
This task assumes that you have created your own layer as described in the section [Create Your Own Layer](#create-layer).
Note that this works for other recipes, too. 
For example, if you plan to modify the Linux kernel, use  `linux-s32` as recipe name.

1. If not already done go to the build directory of the machine and call:

    `# . SOURCE_THIS`

    This configures and starts bitbake.

2. Call devtool with the recipe for U-Boot as argument:

    ` devtool modify u-boot-s32`

    This creates a layer called "workspace" which contains the U-Boot
    sources as a GIT-repository. The sources can be found in the directory
    `workspace/sources/u-boot-s32`.

    Note: if you have done this step before, for example from a previous
    modification, then you have to call:

    `# devtool modify --no-extract u-boot-s32`

    with the additional option `--no-extract`. In this case devtool expects that
    the source tree already exists.

3. Modify the sources with your favourite editor.
    Build your U-Boot with:

    `# devtool build u-boot-s32`

    You can find the results in `workspace/sources/u-boot-s32/oe-workdir/image/boot`.
    The resulting U-Boot images are:

    - u-boot.bin-sdcard
    - u-boot.bin-qspi

    (The results for the Linux kernel can be found in  
    `workspace/sources/linux-s32/oe-workdir/image/boot`)

    If you now want to test your new U-Boot you can create a new boot image with:

    `# devtool build-image microsys-image-auto`

    You can find the output files in `tmp/deploy/images/s32g274ar2sbc3`.

4. Once you're done with your changes finish your work

    - go to `workspace/sources/u-boot-s32` and commit your changes using `git`

    - Update the recipe with:

        `# devtool finish u-boot-s32 meta-mylayer`

    This copies and saves your changes into meta-mylayer.

    If you plan to make more modifications to U-Boot it's better not to delete
    the source tree from the `workspace` directory. Keep it.

    Note: If you think that you are done with all of your changes then you can remove
    the recipe from the workspace layer with:

    `# devtool reset u-boot-s32`

    This will  **erase all**  of your changes from workspace.

5. Now you can rebuild your image including your changes with:

    `# bitbake microsys-image-auto`

Note: if you want to modify the Linux kernel configuration you can call:

`# bitbake -c menuconfig linux-s32`

## Generating the Cross-Toolchain

For cross-development on the host you can generate and install a cross-toolchain
using Yocto build environment.

```
# bitbake -c populate_sdk microsys-image-auto
```

This generates a self-extractor (shar) in the directory `tmp/deploy/sdk` called
`microsys-auto-glibc-x86_64-aarch64-toolchain-<version>.sh` which can be installed on
your build host.

## Exchange the Boot Sequence

Important note: the described method is only intended for development or evaluation.
It is **not** recommended for production or for use in the field!

The following steps exchange the boot media:

- boot into U-Boot

- type:

    ```
    => i2c dev 0
    => i2c read 50 0.1 4 90000000
    => i2c read 56 0.1 4 90000010
    ```

- optionally, you can check the contents with:

    ```
    => md.b 90000000
    90000000: 40 01 0f 00 00 00 00 00 00 00 00 00 00 00 00 00    @...............
    90000010: 00 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00    ................
    ```

    Note: this is sample output from s32g274ar2sbc3

- now re-program the EEPROMs:
    ```
    => i2c write 90000010 50 0.1 4 -s
    => i2c write 90000000 56 0.1 4 -s
    ```

Note: do the above steps in one go without reset or power-cycle!

## Change the maximum temperature threshold

The maximum temperature threshold is controlled by the `temp_max_hex` u-boot variable.
You can set it (to e.g. 105 degrees C) using:

``` bash
=> setenv temp_max_hex 69
```

before running the default bootcommand using

``` bash
=> run bootcmd
```


## Save Disk Space

You can tell bitbake to clean temporary files via adding "rm_work" to
the variable `INHERIT` in the file `local.conf` of the machine build directory.

# Start Firmware on CM7_0 Core

It is assumed that you have already built a firmware image for CM7_0 core, for example with
S32 Design Studio.
You can load and start the image in U-Boot with the following commands:

    => setenv fw_file m7_example.bin
    => setenv fw_start_addr 0x34300000
    => setenv fw_entry_addr 0x34501000
    => setenv load_fw 'dcache off; initsram 0x34100000 0x700000; ext4load mmc 0:1 ${fw_start_addr} ${fw_file}; startm7 ${fw_entry_addr}'
    => run load_fw

Note that the addresses in `fw_start_addr` and `fw_entry_addr` can differ
depending of what you have compiled in.

## Usage of the HSE

The usage of HSE requires agreements with NXP.
In case the HSE shall be used, version 0.2.51.0 shall be used for S32G2XX SoCs.

