# Copyright (C) 2019-2025 MicroSys Electronics GmbH
# Authors:
# - Kay Potthoff <kay.potthoff@microsys.de>
# - Falk Schönfeld <falk.schoenfeld@microsys.de>

inherit image_types_fsl_sdcard
inherit image_types_microsys_flashimage

KERNEL_IMAGETYPE = "Image.gz"
UBOOT_KERNEL_IMAGETYPE = "Image.gz"
SDCARD_ROOTFS_REAL = "${SDCARD_ROOTFS}"
BOOT_SPACE = "131072"

# This should be a list of : <package>:<file> and the file
# should be deployed in ${DEPLOY_DIR_IMAGE}
# SDCARDIMAGE_BOOT_EXTRA_FILES ?= ""

do_image_sdcard[depends] += " \
    ${@d.getVar('ATF_IMAGE_FILE', True) and d.getVar('ATF_IMAGE', True) + ':do_deploy' or ''} \
"

do_image_sdcard[depends] += " \
    ${@d.getVar('IMAGE_BOOTLOADER', True) and d.getVar('IMAGE_BOOTLOADER_RECIPE', True) + ':do_deploy' or ''} \
"

IMAGE_TYPEDEP_tfa-sdcard:append = " ${@d.getVar('SDCARD_ROOTFS', 1).split('.')[-1]}"

IMAGE_CMD:qspi () {
    QSPIIMG="${IMGDEPLOYDIR}/${IMAGE_NAME}${IMAGE_NAME_SUFFIX}.qspi"

    IMG_SIZE=$(expr 3 \* 1024) # == 3MB

    dd if=/dev/zero of=${QSPIIMG} bs=1k count=0 seek=${IMG_SIZE}
    dd if=${DEPLOY_DIR_IMAGE}/${FLASHIMAGE_UBOOT_FILE} of=${QSPIIMG} conv=notrunc,fsync bs=512 seek=0
}

IMAGE_CMD:ramdisk () {
    mkimage -A arm -T ramdisk -d ${IMGDEPLOYDIR}/${IMAGE_NAME}${IMAGE_NAME_SUFFIX}.cpio.gz ${IMGDEPLOYDIR}/${IMAGE_NAME}${IMAGE_NAME_SUFFIX}.ramdisk
}

IMAGE_FSTYPES:remove = "flashimage"
IMAGE_TYPEDEP:sdcard:append = " microsys_flashimage"

### takeover code

# copied from NXP and modified slightly
# more explanations in their recipe in meta-alb/meta-alb-bsp/classes/image_types_fsl_sdcard.bbclass
generate_nxp_sdcard () {
    # Get partitions' start offsets passed as parameters
    SDCARD_ROOTFS_REAL_START="$1"
    SDCARD_ROOTFS_EXTRA1_START="$2"
    SDCARD_ROOTFS_EXTRA2_START="$3"
    SDCARD_EXTENDED_PART_START="$4"

    # Create partition table
    parted -s "${SDCARD}" mklabel msdos

    if [ ${FW_SPACE_ALIGNED} -gt 0 ]; then
        parted -s "${SDCARD}" unit KiB mkpart primary ${IMAGE_ROOTFS_ALIGNMENT} $(printf "%u + %u\n" ${IMAGE_ROOTFS_ALIGNMENT} ${FW_SPACE_ALIGNED} | bc)
    fi

    if [ ${BOOT_SPACE_ALIGNED} -gt 0 ]; then
        parted -s "${SDCARD}" unit KiB mkpart primary ext4 ${BOOT_SPACE_START} $(printf "%u + %u\n" ${BOOT_SPACE_START} ${BOOT_SPACE_ALIGNED} | bc)
    fi

    # main functional change to NXP function
    # U-boot won't recognize partition without ext4
    # bbnote "create_rootfs_partition ${SDCARD_ROOTFS_REAL_START} ${ROOTFS_SIZE} ${SDCARD_ROOTFS_REAL} primary ext4"
    create_rootfs_partition ${SDCARD_ROOTFS_REAL_START} ${ROOTFS_SIZE} "${SDCARD_ROOTFS_REAL}" "primary ext4"

    parted "${SDCARD}" print

    # Fill optional Layerscape RCW into the boot block
    if [ -n "${SDCARD_RCW_NAME}" ]; then
      generate_sdcardimage_entry "${SDCARD_RCW_NAME}" "" 0x00001000
    fi

    _burn_bootloader

    if [ ${FW_SPACE_ALIGNED} -gt 0 ]; then
        _burn_firmware 1
    fi

    # Burn Partitions
    if [ ${BOOT_SPACE_ALIGNED} -gt 0 ]; then
        if [ ${FW_SPACE_ALIGNED} -gt 0 ]; then
            BOOT_PART=2
        else
            BOOT_PART=1
        fi

        _generate_boot_image ${BOOT_PART}
        generate_sdcardimage_entry_raw "${WORKDIR}/boot.ext4" "" $(printf "%u * 1024\n" ${BOOT_SPACE_START} | bc)
    fi

    write_rootfs_partition ${SDCARD_ROOTFS_REAL_START} ${ROOTFS_SIZE} "${SDCARD_ROOTFS_REAL}"
}


IMAGE_CMD:sdcard () {
    if [ -n "${UBOOT_BOOTSPACE_OFFSET}" ]; then
        UBOOT_BOOTSPACE_OFFSET=$(printf "%u" ${UBOOT_BOOTSPACE_OFFSET})
    else
        UBOOT_BOOTSPACE_OFFSET=$(printf "%u * 512\n" ${UBOOT_BOOTSPACE_SEEK} | bc)
    fi

    # Align firmware & boot partitions and calculate total SD card image size
    # Their corresponding partitions will not be created if either BOOT_SPACE or FIMWARE_SPACE is 0 .
    FW_SPACE_ALIGNED=$(printf "s=%u;a=%u;x=s+a-1;x-x%%a\n" ${FIRMWARE_SPACE} ${BASE_IMAGE_ROOTFS_ALIGNMENT} | bc)
    BOOT_SPACE_ALIGNED=$(printf "s=%u;a=%u;x=s+a-1;x-x%%a\n" ${BOOT_SPACE} ${BASE_IMAGE_ROOTFS_ALIGNMENT} | bc)

    # If the size has not been preset, we default to flash image
    # sizes if available turned into [KiB] or to a hardcoded mini
    # default of 4MB.
    if [ -z "${IMAGE_ROOTFS_ALIGNMENT}" ]; then
        if [ -n "${FLASHIMAGE_SIZE}" ]; then
            IMAGE_ROOTFS_ALIGNMENT=$(printf "%u * 1024\n" ${FLASHIMAGE_SIZE} | bc)
        else
            IMAGE_ROOTFS_ALIGNMENT=${BASE_IMAGE_ROOTFS_ALIGNMENT}
        fi
    fi

    # Compute final size of SDCard image and start offset of each rootfs partition
    BOOT_SPACE_START=$(printf "%u + %u\n" ${IMAGE_ROOTFS_ALIGNMENT} ${FW_SPACE_ALIGNED} | bc)
    SDCARD_SIZE=$(printf "%u + %u\n" ${BOOT_SPACE_START} ${BOOT_SPACE_ALIGNED} | bc)

    if [ -n "${SDCARD_ROOTFS_REAL}" ]; then
        SDCARD_ROOTFS_REAL_START=${SDCARD_SIZE}
        SDCARD_SIZE=$(printf "%u + %u + %u\n" ${SDCARD_SIZE} ${ROOTFS_SIZE} ${BASE_IMAGE_ROOTFS_ALIGNMENT} | bc)
    else
        SDCARD_ROOTFS_REAL_START="0"
    fi

    if [ ${SDCARD_ROOTFS_LOGICAL_EXTRA} -eq 1 ]; then
        SDCARD_EXTENDED_PART_START=${SDCARD_SIZE}
        SDCARD_SIZE=$(printf "%u + %u\n" ${SDCARD_SIZE} ${BASE_IMAGE_ROOTFS_ALIGNMENT} | bc)
    else
        SDCARD_EXTENDED_PART_START="0"
    fi

    if [ -n "${SDCARD_ROOTFS_EXTRA1_FILE}" ]; then
        bbnote "found SDCARD_ROOTFS_EXTRA1_FILE, adding size ${SDCARD_ROOTFS_EXTRA1_SIZE}"
        SDCARD_ROOTFS_EXTRA1_START=${SDCARD_SIZE}
        SDCARD_SIZE=$(printf "%u + %u + %u\n"  ${SDCARD_SIZE} ${SDCARD_ROOTFS_EXTRA1_SIZE} ${BASE_IMAGE_ROOTFS_ALIGNMENT} | bc)
    else
        SDCARD_ROOTFS_EXTRA1_START="0"
    fi

    if [ -n "${SDCARDIMAGE_EXTRA1_FILE}" ]; then
        bbnote "found SDCARDIMAGE_EXTRA1_FILE, adding size ${SDCARDIMAGE_EXTRA1_SIZE}"
        SDCARDIMAGE_EXTRA1_OFFSET=${SDCARD_SIZE}
        SDCARD_SIZE=$(printf "%u + %u + %u\n"  ${SDCARD_SIZE} ${SDCARDIMAGE_EXTRA1_SIZE} ${BASE_IMAGE_ROOTFS_ALIGNMENT} | bc)
    else
        SDCARDIMAGE_EXTRA1_OFFSET="0"
    fi

    # ADD more sizes here if necessary

    cd "${IMGDEPLOYDIR}"

    # Initialize a sparse file
    SDIMAGE_SIZE_D=$(printf "%u * 1024\n" ${SDCARD_SIZE} | bc)
    dd if=/dev/zero "of=${SDCARD}" bs=1 count=0 oflag=seek_bytes seek=${SDIMAGE_SIZE_D}

    rawimage_initutils "SD card/eMMC image" "no" ${SDIMAGE_SIZE_D};

    # Additional elements for the raw image, copying the approach of the flashimage class
    generate_sdcardimage_entry "${SDCARDIMAGE_EXTRA1_FILE}" "SDCARDIMAGE_EXTRA1_OFFSET" "${SDCARDIMAGE_EXTRA1_OFFSET}"
    # generate_sdcardimage_entry "${SDCARDIMAGE_EXTRA2_FILE}" "SDCARDIMAGE_EXTRA2_OFFSET" "${SDCARDIMAGE_EXTRA2_OFFSET}"

    generate_nxp_sdcard ${SDCARD_ROOTFS_REAL_START} ${SDCARD_ROOTFS_EXTRA1_START} ${SDCARD_ROOTFS_EXTRA2_START} ${SDCARD_EXTENDED_PART_START}
    cd -
}

# Generate the boot image with the boot scripts and required Device Tree files
# modification by microsys:
# - ext4 instead of fat32
# - include the flashimage
_generate_boot_image() {
    local boot_part=$1

    rm -rf "${WORKDIR}/boot.ext4" ./bootcontents
    bvid="`echo ${BOOTDD_VOLUME_ID} | head -c 10`"

    # prep files for boot image in folder
    mkdir -p ./bootcontents

    # copy boot image
    cp -r -L "${DEPLOY_DIR_IMAGE}/${UBOOT_KERNEL_IMAGETYPE}-${MACHINE}.bin" "./bootcontents/${UBOOT_KERNEL_IMAGETYPE}"

    # copy boot scripts
    # use with SDCARDIMAGE_BOOT_EXTRA_FILES; adds dependencies based on the file which is why it is NOT used for the flashimage
    for item in ${BOOT_SCRIPTS}; do
        src="`echo $item | awk -F':' '{ print $1 }'`"
        dst="`echo $item | awk -F':' '{ print $2 }'`"
    cp -r  -L ${DEPLOY_DIR_IMAGE}/${src} ./bootcontents/${dst}
    done

    # Copy device tree file
    if test -n "${KERNEL_DEVICETREE}"; then
        kernel_bin="`readlink ${DEPLOY_DIR_IMAGE}/${KERNEL_IMAGETYPE}-${MACHINE}.bin`"
        for DTS_FILE in ${KERNEL_DEVICETREE}; do
            DTS_BASE_NAME="`basename ${DTS_FILE} | awk -F "." '{print $1}'`"
            DTB_PATH=""
            kernel_bin_for_dtb=""
            if [ -e "${DEPLOY_DIR_IMAGE}/${KERNEL_IMAGETYPE}-${DTS_BASE_NAME}.dtb" ]; then
                DTB_PATH="${DEPLOY_DIR_IMAGE}/${KERNEL_IMAGETYPE}-${DTS_BASE_NAME}.dtb"
                kernel_bin_for_dtb="`readlink $DTB_PATH | sed "s,$DTS_BASE_NAME,${MACHINE},;s,\.dtb$,.bin,g"`"
            else if [ -e "${DEPLOY_DIR_IMAGE}/${DTS_BASE_NAME}.dtb" ]; then
                    DTB_PATH="${DEPLOY_DIR_IMAGE}/${DTS_BASE_NAME}.dtb"
                    kernel_bin_for_dtb="`readlink $DTB_PATH | sed "s,$DTS_BASE_NAME,${KERNEL_IMAGETYPE},;s,\.dtb$,.bin,g"`"
                fi
            fi
            if [ -n "$DTB_PATH" ]; then
                # match dtb and kernel image by timestamp
                if [ "$kernel_bin" = "$kernel_bin_for_dtb" ]; then
                    cp -r -L "$DTB_PATH" "./bootcontents/${DTS_BASE_NAME}.dtb"
                fi
            else
                bbfatal "${DTS_FILE} does not exist."
            fi
        done
    fi

    # Copy extlinux.conf to images that have U-Boot Extlinux support.
    if [ "${UBOOT_EXTLINUX}" = "1" ]; then
    mkdir -p ./bootcontents/extlinux
        cp -r -L "${DEPLOY_DIR_IMAGE}/extlinux.conf" ./bootcontents/extlinux/extlinux.conf
    fi

    # bbnote "DEPLOY_DIR_IMAGE\n$(ls ${DEPLOY_DIR_IMAGE})\n"
    # bbnote "FLASHIMAGE_DEPLOYDIR\n$(ls ${FLASHIMAGE_DEPLOYDIR})\n"

    cp -r -L "${FLASHIMAGE_DEPLOYDIR}/${SDCARD_BOOT_EXTRA1_FILE}" "./bootcontents/"
    cd ./bootcontents/
    # link with generic name for simplified flash commands
    ln -sf "${SDCARD_BOOT_EXTRA1_FILE}" "microsys-image-auto.flashimage"
    cd -

    # Add extra boot images in the SDCARD boot partition
    # for file in ${@" ".join(get_files_from_extra_files(d))}
    # do
    # if [ -n "${file}" ]; then
        # cp -r "${DEPLOY_DIR_IMAGE}/${file}" "./bootcontents/"
    # else
        # bbfatal "extra boot image ${file} given, but not found in ${DEPLOY_DIR_IMAGE}"
    # fi
    # done


    mkfs.ext4 -L "$bvid" -F -i 4096 -d ./bootcontents ${WORKDIR}/boot.ext4 ${BOOT_SPACE}
}
